/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRecorderExecOptionsProvider.java,v 1.3 2006/05/31 21:26:23 jnevicos Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.framework;

import java.io.File;


/**
 * A recorder provider to provide execution options, like VM args, jar locations,
 * and additional classpath entries.
 * 
 * An IRecorderExecOptionsProvider is accessed during recorder initialization.
 * The results of getRecorderJars() are automatically deployed to the remote agent. 
 * 
 * @see org.eclipse.tptp.test.provisional.recorder.framework.AbstractRecorderExecOptionsProvider
 * @author jnevicos
 */
public interface IRecorderExecOptionsProvider  extends IRecorderProvider {

	public String getVMArgs();
	
	/** 
	 * Adds additional entries to agent's CLASSPATH.  DO NOT include the deployed
	 * JARs listed in getRecorderJars()
	 * @return a semicolon delimited list which is to be added to the CLASSPATH
	 */
	public String getExtraClasspathEntries();
	
	/**
	 * returns jars to be deployed on the agent controller, and added to the agent's classpath
	 * @return an array of java.io.Files.  The File should have a full path, not a relative path.
	 */
	public File[] getRecorderJars();
}
