/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRecorderMessageProvider.java,v 1.3 2006/05/31 21:26:23 jnevicos Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.framework;

import java.io.IOException;


/**
 * A recorder provider to provide additonal interpreters for incoming messages.
 * An IRecorderMessageProvider interprets messages sent from the RecorderAgent over the data channel.
 * 
 * These messages are specified as a message (String) or data (a byte[]) and 
 * processed by the appropriate handler message.
 * 
 * The implementing provider can then break down the data further into subcategories
 * For an example of this:
 * @see org.eclipse.tptp.test.provisional.recorder.messages.AbstractRecorderMessageProvider
 * 
 * @author jnevicos
 */
public interface IRecorderMessageProvider extends IRecorderProvider {

	/** Called via the data processor to process a control string from the agent.
	 * If using AbstractRecorderMessageProvider, if none of the default messages were 
	 * handled, then processCustomMessages(String) is called.
	 * 
	 * @param str
	 * @return true if the message is handled
	 */
	public boolean processMessage(String str);
	
	/**
	 * 
	 * @param data
	 * @return
	 */
	public boolean processDataFromDataProcessor(byte[] data);
	
	public void initialize() throws IOException;
	
	public void complete();
	
	
}
