/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRecorderProvider.java,v 1.3 2006/05/31 21:26:23 jnevicos Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.framework;

import org.eclipse.hyades.execution.recorder.Recorder;

/**
 * Interface for shared Recorder Provider methods.
 * Do NOT directly implement this interface!
 * 
 * Note: extending any of the default or abstract classes will implement these
 * core methods in the appropriate manner.
 * @author jnevicos
 * @see RecorderClientHelperAdapter
 * @see AbstractRecorderExecOptionsProvider
 * @see AbstractRecorderMessageProvider
 * @see DefaultRecWizardProvider
 */
public interface IRecorderProvider   {

	public void setRecorder(String id);
	
	/**
	 * Sets a Recorder object.  Provided for compatibility with old 
	 * recorder framework.
	 * @param recorder
	 */
	public void setRecorder(Recorder recorder);
	
	public Recorder getRecorder();
	
	public String getRecorderID();
}
