/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecorderClientHelperAdapter.java,v 1.3 2006/05/31 21:26:23 jnevicos Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.framework;

import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;

/**
 * Adapter for the RecorderClientHelper.  Note that preSetup() MUST be implemented.
 * @author jnevicos
 * @see IRecorderClientHelper 
 */
public abstract class RecorderClientHelperAdapter implements IRecorderClientHelper {

	private Recorder recorder;
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper#okToLaunch()
	 */
	public boolean okToLaunch() {
		// TODO Auto-generated method stub
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper#preSetup()
	 */
	public abstract boolean preSetup();
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper#preStartRecording()
	 */
	public boolean preStartRecording() {
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper#postStartRecording()
	 */
	public boolean postStartRecording() {
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper#preStopRecording()
	 */
	public boolean preStopRecording() {
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper#postStopRecording()
	 */
	public boolean postStopRecording() {
		return true;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper#cleanup()
	 */
	public boolean cleanup() {
		// TODO Auto-generated method stub
		return false;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper#getRecorder()
	 */
	public Recorder getRecorder() {
		return recorder;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider#getRecorderID()
	 */
	public String getRecorderID() {
		return recorder.getId();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider#setRecorderID(java.lang.String)
	 */
	public void setRecorder(String id) {
		recorder = RecorderFactory.getInstance().getRecorderWithID(id);
		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider#setRecorder(org.eclipse.hyades.execution.recorder.Recorder)
	 */
	public void setRecorder(Recorder recorder) {
		this.recorder = recorder;		
	}
}
