/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IAgentListener.java,v 1.4 2007/04/20 19:27:53 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.execution.client.agent;

import org.eclipse.tptp.platform.execution.util.ICommandElement;
/**
 * Agent Event Interface
 * @provisional
 */

public interface IAgentListener {
	
	/**
	 * Invoked when an agent first becomes active
	 * @param Agent
	 */
	void agentActive(IAgent agent);
	
	/**
	 * Invoked when an agent becomes inactive.
	 * @param Agent
	 */
	void agentInactive(IAgent agent);
	
	/**
	 * Invoked when an error is recieved from the agent.
	 * @param Agent
	 * @param errorMessage
	 */
	void error(IAgent agent, String errorMessage);
}

