/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: ICollector.java,v 1.4 2007/04/19 05:29:09 gnagarajan Exp $ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.client.agent;

/**
 * Collector is a type of agent primarily supporting data collection 
 * and agent control operations.  
 * @provisional
 * @since tptp 4.0
 */

public interface ICollector extends IAgent {

	/**
	 * Start the data collection process
	 */
	void run();
	
	/**
	 * Pause the data collection process
	 */
	void pause();

	/**
	 * Resume the data collection process
	 */
	void resume();

	/**
	 * Cancel the data collection process
	 */
	void cancel();

	/**
	 * Stop the data collection process
	 */
	void stop();
	
	/**
	 * Checks if agent is running and returns true/false
	 */
	boolean isAgentRunning();
	
	/**
	 * Return the current state of the data collection process
	 * @return int
	 * @deprecated since TPTP 4.0
	 * See Agent Management document for Agent Event Management 
	 */
	int getAgentState();
}
