/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id$
 * 
 * Contributors: 
 * Vishnu K Naikawadi, Intel - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.execution.client.agent.internal;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;
import java.io.IOException;
import org.eclipse.tptp.platform.execution.client.agent.*;
import org.eclipse.tptp.platform.execution.client.core.*;
import org.eclipse.tptp.platform.execution.client.core.internal.*;
import org.eclipse.tptp.platform.execution.exceptions.*;
import org.eclipse.tptp.platform.execution.util.*;
import org.eclipse.tptp.platform.execution.util.internal.CommandFragment;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.DimeHeader;
import org.eclipse.tptp.platform.execution.util.internal.TPTPXMLParse;

public class AgentImpl implements IAgent, IProcessListener, IConnectionListener 
{ // Bug 59316
	protected String _name=null;
	protected String _type=null;
	protected String _uuid=null;
	protected String _version = null;
	private IAgentController _ac = null;
	protected boolean _autoAttach=false;
	//public boolean _isMonitored=false;
	protected boolean _isActive=true;
	//protected boolean _isAttached=false;
	protected String _profileFile=null;
	protected IProcess _process = null;
	protected String agentMetadata = null;
	protected TPTPAgentAccess agentMode = null;
	private int _agentID = -1;
	private int _tokenID = -1;
	private int _dataConnectionID = -1;
	//private boolean dataPathEstablished = false;
	private Object _datapathLock = new Object();
	protected Vector _listeners=new Vector(10);
	protected AgentState _agentState = null;
	protected IDataProcessor _dataProcessor = null;
	
	public AgentImpl()
	{}
	
	public AgentImpl(String name) 
	{
		_name = name;		
	}
	
	
	public AgentImpl(String name, String type) 
	{
		_name = name;
		_type = type;
	}
	
	public IAgentController getAgentController()
	{
		return _ac;
	}
	
	public void setAgentController(IAgentController ac)
	{
		_ac = ac;
	}	

	/**
	 * @see Agent#addAgentListener(AgentListener)
	 */
	public void addAgentListener(IAgentListener listener) {
		synchronized(_listeners) {
			if(!_listeners.contains(listener)) {
				_listeners.add(listener);
			}
		}
	}

	/**
	 * @see Agent#removeAgentListener(AgentListener)
	 */
	public void removeAgentListener(IAgentListener listener) {
		synchronized(_listeners) {
			if(_listeners.contains(listener)) {
				_listeners.remove(listener);
			}	
		}
	}

	/**
	 * @see Agent#removeAgentListener(AgentListener)
	 */
	public Vector getAgentListener() {
				return _listeners;
	}
	

    /**
     * Change the type of the agent
      * @param type  value of the new type
     */
    public void setType(String type) 
    {
    	_type = type;
    }

	
    /**
     * Change the name of the agent
     * @param name the new agent's name
     */
    public void setName(String name)
    {
    	_name = name;
    }
	
	
	/**
	 * Retrieve the instance id of this agent.
	 * @return the id of the agent if it is known, negative if it is not assigned yet
	 */
	 public int getAgentInstanceId()
	 {
	 	return _agentID;
	 }
	
	 
    /**
     * Change the agent instance's id
     * @param uuid the new uuid's value 
     */
    public void setAgentInstanceId(int id)
    {
    	_agentID = id;
    }
    /**
	 * Retrieve the instance id of this agent.
	 * @return the id of the agent if it is known, negative if it is not assigned yet
	 */
	 public int getAgentTokenId()
	 {
	 	return _tokenID;
	 }
	
	 
    /**
     * Change the agent instance's id
     * @param uuid the new uuid's value 
     */
    public void setAgentTokenId(int id)
    {
    	_tokenID = id;
    }

	
	/**
	 * Retrieve the version of this agent.
	 * @return the version
	 */
	 public String getVersion()
	 {
	 	return _version;
	 }
	
	 
    /**
     * Set the Agent version
     * @param version  the new version number 
     */
    public void setVersion(String version)
    {
    	_version = version;
    }
    
    
    /**
     * Set the Process associated with Agent
     * @param version  the new version number 
     */
    public void setProcess(IProcess process)
    {
    	_process = process;
    	_agentState = null;
    	// get shared state between different instances of agents
    	if (_ac != null && _process != null) {
			long pid;
			try {
				pid = _process.getProcessId();
				_agentState = AgentStatePool.createAgentInfo(_ac.getConnectionInfo(), pid);
			} catch (InactiveProcessException e) {
				e.printStackTrace();
			}
		}

    	//Update the agent status in the process list with the same id since the objects may be cast differently
    	/*if(_process == null) return;
    	try
    	{
    		if(((AgentController)(this._ac))._agentList.containsKey(String.valueOf(getProcess().getProcessId())))
    		{
    			ArrayList temp = (ArrayList)((AgentController)(this._ac))._agentList.get(String.valueOf(getProcess().getProcessId()));
    			for(int i = 0; i < temp.size();i++)
    			{
    				IAgent tempagent = (IAgent)temp.get(i);
    				this._isMonitored = ((AgentImpl)tempagent)._isMonitored;
    				this._isAttached = ((AgentImpl)tempagent)._isAttached;
    				this.dataPathEstablished = ((AgentImpl)tempagent).dataPathEstablished;
    			}
    		}
		}
    	catch(Exception e)
    	{
    		return;
    	}*/
    }
    
    /**
     * Get the Process assocites with Agent
     * @param version  the new version number 
     */
    public IProcess getProcess()
    {
    	return _process;
    }

    /**
     * Add a listener for agent events
     * @param listener to handle the event notification 
     */
    public long addEventListener(String interfaceID, ICommandHandler listener) 
    {
		StringBuffer AddEventListenerCommand = new StringBuffer("");
		long listenerID = -1;
		
		try
		{
			listenerID = _ac.getNextContextId();
			//System.out.println("Sending addEventListener() command");
			AddEventListenerCommand.append("<addEventListener iid=\"org.eclipse.tptp.eventProvider\"><interfaceID>");
			AddEventListenerCommand.append(interfaceID);
			AddEventListenerCommand.append("</interfaceID><listenerID>");
			AddEventListenerCommand.append(listenerID);
			AddEventListenerCommand.append("</listenerID></addEventListener>");
			//System.out.print("The Add Event Listener Command is - " + AddEventListenerCommand.toString());
			IConnection conn = ((AgentController)_ac).getConnection();
			((ConnectionImpl)conn).addContext(listenerID, listener);			
			sendCommand(AddEventListenerCommand.toString(), new ICommandHandler()
			{
				public void incomingCommand(INode node, ICommandElement command) 
				{
					handleAgentCommand(command);
				}
			});
		}
		catch(Exception exp)
		{
			exp.printStackTrace();
		}
		
		return listenerID;
    }

    /**
     * Remove a listener for agent events
     * @param listener to handle the event notification 
     */
    public void removeEventListener(String interfaceID, long  listenerID)
    {
		StringBuffer RemoveEventListenerCommand = new StringBuffer("");
		try
		{
			RemoveEventListenerCommand.append("<removeEventListener iid=\"org.eclipse.tptp.eventProvider\"><interfaceID>");
			RemoveEventListenerCommand.append(interfaceID);
			RemoveEventListenerCommand.append("</interfaceID><listenerID>");
			RemoveEventListenerCommand.append(listenerID);
			RemoveEventListenerCommand.append("</listenerID></removeEventListener>");
			sendCommand(RemoveEventListenerCommand.toString(), new ICommandHandler()
			{
				public void incomingCommand(INode node, ICommandElement command) 
				{
					handleAgentCommand(command);
				}
			});
		}
		catch(Exception exp)
		{
			exp.printStackTrace();
		}
    }


	/**
	 * Send the command
	 * @param outCommand  the command to send out
	 * @param handler  processing the response of the command
	 */
	public void sendCommand(ICommandElement outCommand, ICommandHandler respHandler) throws InactiveAgentException
	{
		if(!_isActive) {
			throw new InactiveAgentException(Constants.TPTP_PLATFORM_EXEC_MSG1);
		}
		ControlMessage message=new ControlMessage();
		outCommand.setContext(getAgentController().getNextContextId());
		message.appendCommand(outCommand);		
		try {
		    ((AgentController)getAgentController()).sendMessage(message, new ICommandHandler() {
				public void incomingCommand(INode node, ICommandElement element) {
					handleAgentCommand(element);
				}
			});
		}

		catch(IOException e) {
			/* We need to handle this */
			e.printStackTrace();
		}		
	}

	/**
	 * Send the command
	 * @param outCommand  the command to send out
	 * @param handler   processing the response of the command
	 */
	public void sendCommand(String outCommand, ICommandHandler respHandler) throws InactiveAgentException
	{
		if(!_isActive) {
			throw new InactiveAgentException(Constants.TPTP_PLATFORM_EXEC_MSG1);
		}
		if(_agentID == -1){
			throw new InactiveAgentException(Constants.TPTP_PLATFORM_EXEC_MSG1); 
		}
		try {
			if (respHandler == null)
			{
				((AgentController)getAgentController()).sendCommand(outCommand, _agentID, new ICommandHandler() {
					public void incomingCommand(INode node, ICommandElement element) {
						handleAgentCommand(element);
					}
				});
			}
			else
			{
			    ((AgentController)getAgentController()).sendCommand(outCommand, _agentID, respHandler);
			}
		}

		catch(IOException e) {
			/* We need to handle this */
			e.printStackTrace();
		}		
	}

	/**
	 * @see Agent#isAutoAttach(boolean)
	 */
	public boolean isAutoAttach() {
		return _autoAttach;
	}
	/**
	 * @see Agent#getType()
	 */
	public String getType() {
		return _type;
	}

	/**
	 * @see Agent#getName()
	 */
	public String getName() {
		return _name;
	}
	
	/**
	 * @see Agent#getUUID()
	 */
	public String getUUID() {
		return _uuid;	
	}

	/**
	 * @see Agent#isActive()
	 */
	public boolean isActive() 
	{
		return _isActive;
	}

	/**
	 * @see Agent#isMonitored()
	 */
	public boolean isMonitored() 
	{
		boolean isMonitored = false;
		if (_agentState != null) {
			isMonitored = _agentState.isMonitored;
		}
		return isMonitored;
	}

	public int addDataListener(IDataProcessor dataProcessor)
	{
		if(_dataConnectionID == -1)
		{
			if(_agentState != null)
			{
				_dataConnectionID = _agentState.dataConnectionID;
			}
		}
		_dataProcessor = dataProcessor;
		
		if(_agentState != null)
		{
			_agentState.dataProcessor = dataProcessor;
		}
		return ((AgentController)getAgentController()).addDataListener(_dataConnectionID, dataProcessor);
	}
	
	public void startMonitoring(TPTPDataPath direction)
	{
		if (isMonitored())
			return;
		StringBuffer tempbuf = new StringBuffer();
		Object _dpLock = new Object();
		long agentDataPathDirection = -1;
		try
		{
			if (_dataConnectionID == -1)
			{
				_dataConnectionID = ((AgentController)getAgentController()).createDataConnection(direction.getValue());
				if(_agentState != null)
				{
					_agentState.dataConnectionID = _dataConnectionID;
				}
			}
			if (direction.getValue() == Constants.DATA_PATH_SEND)
			{
				agentDataPathDirection = Constants.DATA_PATH_RECEIVE;
			}
			else if (direction.getValue() == Constants.DATA_PATH_RECEIVE)
			{
				agentDataPathDirection = Constants.DATA_PATH_SEND;
			}
			else if (direction.getValue() == Constants.DATA_PATH_TWO_WAY)
			{
				agentDataPathDirection = Constants.DATA_PATH_TWO_WAY;
			}
			
			//Send the establishDataPath command
			if(Constants.TPTP_DEBUG)System.out.println("Sending establishDataPath() command");
			final GenericCommandHandler genCmdHandler = new GenericCommandHandler();
			tempbuf.append("<establishDataPath iid=\"org.eclipse.tptp.dataProvider\"><dataConnectionID>");
			tempbuf.append(_dataConnectionID);
			tempbuf.append("</dataConnectionID><flags>");
			tempbuf.append(agentDataPathDirection);
			tempbuf.append("</flags></establishDataPath>");
		
			synchronized(_dpLock) 
			{
			   try 
			   { 	
				   	sendCommand(tempbuf.toString(), new ICommandHandler(){
				   			public void incomingCommand(INode node, ICommandElement command)
				   			{	
				   				genCmdHandler.setCommandElement(command);
				   			}
				   		});
				    try{_dpLock.notifyAll();}
				    catch(Exception e){e.printStackTrace();}	
			   }
			   	catch(Exception e){e.printStackTrace();}
			}
			synchronized(_dpLock)
		 	{
				int cntr = 0;
		 	    while(genCmdHandler.getCommandElement() == null )
		 	    {
		 	        try
		 	        {		 	        	
		 	        	_dpLock.wait(Constants.TIMEOUT_PERIOD);
		 	        	if (cntr == Constants.DSSRVR_LAUNCH_TIMEOUT_TRY_COUNT)
		 	        	{
		 	        		throw new TimeoutException(Constants.TPTP_PLATFORM_EXEC_MSG33);		
		 	        	}
		 	        }
		 	        catch(TimeoutException e)
		 	        {
		 	        	_dpLock.notifyAll();
		 	        	//e.printStackTrace();
		 	        	throw e;
		 	        }
		 	        catch(Exception e)
		 	        {
		 	        	_dpLock.notifyAll();
		 	        	//e.printStackTrace();
		 	        	break;
		 	        }
		 	    }
		 	}
			if (genCmdHandler.getCommandElement() == null) {return;}
 			String commandStr = ((CommandFragment)genCmdHandler.getCommandElement()).getCommandData();
 			TPTPXMLParse ParseObj = new TPTPXMLParse();
 			ParseObj.setParser(commandStr);
 			if (Constants.TPTP_DEBUG)System.out.println("Data Path Established "+commandStr);
 			Hashtable CommandHash = ParseObj.getHashTable();
 			if (CommandHash.containsKey("dataPathEstablished"))
 			{
 				if (_agentState != null) {
 					_agentState.dataPathEstablished = true;
 					_agentState.isMonitored = true;
 					_agentState.isAttached = true;
 				}
 				//dataPathEstablished = true;
 				//_isMonitored = true;
 				//_isAttached = true;
 				if(Constants.TPTP_DEBUG)System.out.println("Data Path Established");
 			}	
 			Enumeration en = _listeners.elements();
 			
 			while(en.hasMoreElements()) 
 			{
 				((IAgentListener)en.nextElement()).agentActive(this);
 			}
 			//Update the agent status in the process list with the same id since the objects may be cast differently
 			/*if(((AgentController)(this._ac))._agentList.containsKey(String.valueOf(getProcess().getProcessId())))
 			{
 				ArrayList temp = (ArrayList)((AgentController)(this._ac))._agentList.get(String.valueOf(getProcess().getProcessId()));
 				for(int i = 0; i < temp.size();i++)
 				{
 					IAgent tempagent = (IAgent)temp.get(i);
 					((AgentImpl)tempagent)._isMonitored = true;
 					((AgentImpl)tempagent)._isAttached = true;
 					((AgentImpl)tempagent).dataPathEstablished = true;
 				}
 			}*/
 			
		}
		catch(Exception exp)
		{
			exp.printStackTrace();
			
		}
	}	
	
	/**
	 * @see Agent#startMonitoring()
	 */
	public void startMonitoring(TPTPDataPath direction, IDataProcessor processor) throws InactiveAgentException 
	{
		startMonitoring(direction);
		addDataListener(processor);
	}
	
	/**
	 * @see Agent#startMonitoring()
	 */
	public void startMonitoring(IDataProcessor processor) throws InactiveAgentException 
	{
		startMonitoring(TPTPDataPath.DATA_PATH_RECEIVE);
		addDataListener(processor);
	}
	
	/**
	 * @see Agent#startMonitoring()
	 */
	public void stopMonitoring(IDataProcessor processor) throws InactiveAgentException 
	{
		stopMonitoring();
	}
	
	/**
	 * @see Agent#stopMonitoring()
	 */
	public void stopMonitoring() throws InactiveAgentException 
	{
		if(_agentState != null)
		{
			if(!_agentState.isMonitored)
				return;
		}
		StringBuffer tempbuf = new StringBuffer();
		try
		{
			if (_dataConnectionID == -1)
			{
				if (_agentState != null) {
 					_dataConnectionID = _agentState.dataConnectionID;
					_agentState.isMonitored = false;
 				}
			}
			if(Constants.TPTP_DEBUG)System.out.println("Sending ReleaseDataPath() command");
			tempbuf.append("<releaseDataPath iid=\"org.eclipse.tptp.dataProvider\"><dataConnectionID>");
			tempbuf.append(_dataConnectionID);
			tempbuf.append("</dataConnectionID></releaseDataPath>");
			sendCommand(tempbuf.toString(), new ICommandHandler()
			{
				public void incomingCommand(INode node, ICommandElement command) 
				{
					
				}
			});
			if(_agentState != null)
			{
				IConnection conn = ((AgentController)getAgentController()).getConnection();
				((ConnectionImpl)conn).removeDataListener(_agentState.dataConnectionID, _agentState.dataProcessor);
			}
			_dataConnectionID = -1;
			_dataProcessor = null;
			if (_agentState != null) {
				_agentState.isMonitored = false;
				_agentState.isAttached = false;
				_agentState.dataConnectionID = _dataConnectionID;
				_agentState.dataProcessor = null;
			}
			
			Enumeration en = _listeners.elements();
 			while(en.hasMoreElements()) {
 				((IAgentListener)en.nextElement()).agentInactive(this);
 			}
 			/*if(((AgentController)(this._ac))._agentList.containsKey(String.valueOf(getProcess().getProcessId())))
 			{
 				ArrayList temp = (ArrayList)((AgentController)(this._ac))._agentList.get(String.valueOf(getProcess().getProcessId()));
 				for(int i = 0; i < temp.size();i++)
 				{
 					IAgent tempagent = (IAgent)temp.get(i);
 					((AgentImpl)tempagent)._isMonitored = false;
 					((AgentImpl)tempagent)._isAttached = false;
 					((AgentImpl)tempagent).dataPathEstablished = false;
 				}
 			}*/
		}
		catch(Exception exp) {
			if (_agentState != null) {
				_agentState.isMonitored = false;
			}
			//_isMonitored=false;
		}
	}
	
	public void sendData(byte[] buffer, int bufferLength) throws DataChannelConnectionException
	{
		byte[] buf = DimeHeader.shipIt(buffer, bufferLength);
		if(buf != null)
		{
			((AgentController)this._ac).sendData(this._dataConnectionID, buf, buf.length);
		}
	}
	
	public void sendDataWithoutDime(byte[] buffer, int bufferLength) throws DataChannelConnectionException
	{
		if(buffer != null)
		{
			((AgentController)this._ac).sendData(this._dataConnectionID, buffer, bufferLength);
		}
	}
	
	public void sendData(byte[] buffer) throws DataChannelConnectionException
	{
		this.sendData(buffer, buffer.length /*Length*/);
	}
	public void releaseAccess()
	{
		try
		{
		    ((AgentController)getAgentController()).releaseAgent(this._agentID);
			this.setAgentMode(null);
		}
		catch(Exception exp)
		{
		    exp.printStackTrace();
		}
	}

	public boolean requestControl()
	{
	    boolean reqgrant = false;
	    try 
	    {
	      reqgrant = ((AgentController)getAgentController()).requestAgentControl(this._agentID, TPTPAgentAccess.TPTP_CONTROLLER_ACCESS.getValue());
	      if(reqgrant){this.setAgentMode(TPTPAgentAccess.TPTP_CONTROLLER_ACCESS);}
	    }
	    catch(Exception e){e.printStackTrace();}
	    return reqgrant;
	}

	public void releaseControl()
	{
	    try
	    {
	        ((AgentController)getAgentController()).releaseAgentControl(this._agentID);
	        this.setAgentMode(TPTPAgentAccess.TPTP_OBSERVER_ACCESS);
	        Enumeration en = _listeners.elements();
			while(en.hasMoreElements()) 
			{
				((IAgentListener)en.nextElement()).agentInactive(this);
			}
	    }
	    catch(Exception e){e.printStackTrace();}
	}
	
	public void setUUID(String uuid) {
		_uuid=uuid;	
	}
	
	/**
	 * This is the local handler for
	 */
	public void handleAgentCommand(final ICommandElement command) {
		String commandStr = new String(((CommandFragment)command).getCommandData());
		
		TPTPXMLParse ParseObj = new TPTPXMLParse();
		ParseObj.setParser(commandStr);
		Hashtable CommandHash = ParseObj.getHashTable();
		
		if (CommandHash.containsKey("dataPathEstablished"))
		{
			synchronized(_datapathLock)
			{
				if (_agentState != null) {
 					_agentState.dataPathEstablished = true;
 				}
				//dataPathEstablished = true;
				if(Constants.TPTP_DEBUG)System.out.println("Data Path Established");
				_datapathLock.notifyAll();
			}
		}		
	}
	
	/**
	  * @see ProcessListener#processLaunched
	  */
	public void processLaunched(IProcess process) {	
	}
	
	/**
	  * @see ProcessListener#processExited
	  */
	public void processExited(IProcess process) {

	}	

	// Bug 59316 begins
	public void connectionClosed(IConnection connection) {
		synchronized(_listeners) {
			_isActive = false;
			Enumeration elements = _listeners.elements();
			while(elements.hasMoreElements()) {
				((IAgentListener)elements.nextElement()).agentInactive(this);
			}
		}	
	}
	
	// commented depricated methods
	/*public AgentConfiguration getConfiguration()
	{
		throw new NotSupportedException(Constants.ERR_NOT_SUPPORTED);
	}
	
	public void setConfiguration(AgentConfiguration config)
	{
		throw new NotSupportedException(Constants.ERR_NOT_SUPPORTED);
	}
	
	public void publishConfiguration()
	{
		throw new NotSupportedException(Constants.ERR_NOT_SUPPORTED);
	}*/
	
	/**
	 * @see Agent#attach()
	 */
	public void attach() throws InactiveAgentException, InactiveProcessException{
		throw new NotSupportedException(Constants.ERR_NOT_SUPPORTED);
	}

	/**
	 * @see Agent#detach()
	 */
	public void detach() throws InactiveAgentException, InactiveProcessException {
		throw new NotSupportedException(Constants.ERR_NOT_SUPPORTED);
	}
	
	/**
	 * @see Agent#isAttached()
	 */
	public boolean isAttached() {
		throw new NotSupportedException(Constants.ERR_NOT_SUPPORTED);
	}
	
	/**
	 * @see Agent#isAttached()
	 */
	public boolean isAttached(boolean remote) {
		throw new NotSupportedException(Constants.ERR_NOT_SUPPORTED);
	}

	public int receiveData(char[] buffer) throws InactiveAgentException, NotConnectedException
	{
	    int response = 0;
	    return response;
	}
	public String[] getSupportedInterfaces()
	{
	    //TODO:Get the supported interfaces
	    return new String[10];
	}
	
	public String getAgentMetaData() throws NotConnectedException
	{
	    if(this.getName() == null)
	    {
	       new Exception(Constants.TPTP_PLATFORM_EXEC_MSG2);
	    }
	    try
	    {
	        agentMetadata = ((AgentController)this.getAgentController()).getAgentMetadata(this.getName());
	        return agentMetadata;
	    }
	    catch(NotConnectedException e)
	    {
	        throw new NotConnectedException(Constants.TPTP_PLATFORM_EXEC_MSG3);
	    }
	}
		
	public int getAgentMode()
	{
	    if (agentMode != null) return agentMode.getValue();
	    else return -1;
	}
	/**
	 * Get the Agent reference mode - Observer or Controller
	 * @return int - TPTPAgentAccess
	 */
	public void setAgentMode(TPTPAgentAccess agentMode)
	{
	    this.agentMode = agentMode;
	}
	public boolean requestAccess(org.eclipse.tptp.platform.execution.util.TPTPAgentAccess accessMode)
	{
	    return true;
	}
	
}
