/*******************************************************************************
 * Copyright (c) 2005-2007 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: 
 *    Vishnu K Naikawadi, Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/

package org.eclipse.tptp.platform.execution.client.agent.internal;

import java.util.Hashtable;

import org.eclipse.tptp.platform.execution.client.agent.*;
import org.eclipse.tptp.platform.execution.client.core.*;
import org.eclipse.tptp.platform.execution.client.core.internal.GenericCommandHandler;
import org.eclipse.tptp.platform.execution.util.ICommandElement;
import org.eclipse.tptp.platform.execution.util.ICommandHandler;
import org.eclipse.tptp.platform.execution.util.internal.CommandFragment;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.TPTPXMLParse;
import org.eclipse.tptp.platform.execution.exceptions.TimeoutException;


public class CollectorImpl extends AgentImpl implements ICollector
{
	private boolean agentRunning = false;
	private boolean agentPauseState = false;
	private int _agentState = -1;
	
	public CollectorImpl()
	{
		super();
	}
	
	public CollectorImpl(String name)
	{
		super(name);
	}
	
	public CollectorImpl(String name, String type)
	{
		super(name, type);
	}
	
	/**
	 * Checks if agent is running and returns true/false
	 */
	public boolean isAgentRunning()
	{
		return agentRunning;
	}
	public boolean isAgentPaused()
	{
		return agentPauseState;
	}
	public void run()
	{
		StringBuffer tempbuf = new StringBuffer("");
		try
		{
			if(Constants.TPTP_DEBUG)System.out.println("Sending run() command");
			tempbuf.append("<run iid=\"org.eclipse.tptp.Collector\"></run>");
			sendCommand(tempbuf.toString(), new ICommandHandler()
			{
				public void incomingCommand(INode node, ICommandElement command) 
				{
					handleCommand(command);
				}
			});
			agentRunning = true;
		}	
		catch(Exception exp)
		{
			exp.printStackTrace();
		}
	}
	public void stop()
	{
		StringBuffer tempbuf = new StringBuffer("");
		
		try
		{
			if(Constants.TPTP_DEBUG)System.out.println("Sending stop() command");
			tempbuf.append("<stop iid=\"org.eclipse.tptp.Collector\"></stop>");
			sendCommand(tempbuf.toString(), new ICommandHandler()
			{
				public void incomingCommand(INode node, ICommandElement command) 
				{
					handleCommand(command);
				}
			});			
			agentRunning = false;
		}
		catch(Exception exp)
		{
			exp.printStackTrace();
		}
	}
	
	public void cancel()
	{
		StringBuffer tempbuf = new StringBuffer("");
		
		try
		{
			if(Constants.TPTP_DEBUG)System.out.println("Sending cancel() command");
			tempbuf.append("<cancel iid=\"org.eclipse.tptp.Collector\"></cancel>");
			sendCommand(tempbuf.toString(), new ICommandHandler()
			{
				public void incomingCommand(INode node, ICommandElement command) 
				{
					handleCommand(command);
				}
			});			
			agentRunning = false;
		}
		catch(Exception exp)
		{
			exp.printStackTrace();
		}		
	}
	
	public void pause()
	{
		StringBuffer tempbuf = new StringBuffer("");
		try
		{
			if(Constants.TPTP_DEBUG)System.out.println("Sending pause() command");
			tempbuf.append("<pause iid=\"org.eclipse.tptp.Collector\"></pause>");
			sendCommand(tempbuf.toString(), new ICommandHandler()
			{
				public void incomingCommand(INode node, ICommandElement command) 
				{
					handleCommand(command);
				}
			});	
			agentPauseState = true;
		}
		catch(Exception exp)
		{
			exp.printStackTrace();
		}		
	}
	
	
	public void resume()
	{
		StringBuffer tempbuf = new StringBuffer("");
		try
		{
			if(Constants.TPTP_DEBUG)System.out.println("Sending resume() command");
			tempbuf.append("<resume iid=\"org.eclipse.tptp.Collector\"></resume>");
			sendCommand(tempbuf.toString(), new ICommandHandler()
			{
				public void incomingCommand(INode node, ICommandElement command) 
				{
					handleCommand(command);
				}
			});		
			agentPauseState = false;
		}
		catch(Exception exp)
		{
			exp.printStackTrace();
		}
	}
	
	public int getAgentState()
	{
		StringBuffer tempbuf = new StringBuffer("");
		try
		{
			if(Constants.TPTP_DEBUG)System.out.println("Sending getAgentState() command");
			tempbuf.append("<getAgentState iid=\"org.eclipse.tptp.Collector\"></getAgentState>");
			sendCommand(tempbuf.toString(), new ICommandHandler()
			{
				public void incomingCommand(INode node, ICommandElement command) 
				{
					handleCommand(command);
				}
			});			
		}
		catch(Exception exp)
		{
			exp.printStackTrace();			
		}
		return this._agentState;
	}	
	
	
	public void handleCommand(ICommandElement command)
	{
		String commandStr = new String(((CommandFragment)command).getCommandData());
		if (Constants.TPTP_DEBUG) System.out.println("The Agent response - " + commandStr);
		TPTPXMLParse ParseObj = new TPTPXMLParse();
		ParseObj.setParser(commandStr);
		Hashtable CommandHash = ParseObj.getHashTable();
		if(CommandHash.containsKey("agentRunning"))
		{ 
			agentRunning = true;
			if(Constants.TPTP_DEBUG)System.out.println("Agent is running");
		}
		if(CommandHash.containsKey("agentStopped"))
		{ 
			agentRunning = false;
			if(Constants.TPTP_DEBUG)System.out.println("Agent is stopped");
		}
	}

	
}
