/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id$
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.execution.client.agent.internal;

import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.IAgentListener;

/**
 * Interface to provide Agent Peer Monitoring
 * @since TPTP 3.x
 * @provisional
 */
public interface IAgentPeerListener extends IAgentListener{
	
	
	/**
	 * Invoked when an agent requests to be monitored because this client
	 * is currently monitoring another agent.
	 * @param IAgent
	 * @param IAgent
	 */
	void peerWaiting(IAgent agent, IAgent peer);
}

