/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: ConnectionInfo.java,v 1.6 2007/04/26 14:50:12 samwai Exp $ 
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.client.core;
import java.util.*;

import org.eclipse.tptp.platform.execution.util.internal.*;


/**
 * ConnectionInfo provides the object to encapsulate connection attributes
 * required by INode to connect to the Agent Controller. 
 * @provisional 
 */
public class ConnectionInfo {

	private String _hostname;
	private int _port;
	private Enumeration _protocol;
	private String conn_protocol;
	private boolean _agentControllerNew = false;
	private int _soTimeout = Constants.TIMEOUT_PERIOD;

	/**
	 * ConnectionInfo constructor 
	 */
	public ConnectionInfo() {
		super();
		setAgentControllerNew(Constants.TPTP_AC);
	}

	/**
	 * Get Host Name
	 * @return String
	 */
	public String getHostName()
	{
		return _hostname;
	}
	
	/**
	 * Set Host Name
	 * @param hostname
	 */
	public void setHostName(String hostname)
	{
		_hostname = hostname;
	}
	
	/**
	 * Get the Port Number
	 * @return int
	 */
	public int getPort()
	{
		return _port;
	}

	/**
	 * Return the socket timeout
	 * @return int
	 */
	public int getSoTimeout() {
		return _soTimeout;
	}

	/**
	 * Set the Port Number
	 * @param port
	 */
	public void setPort(int port)
	{
		_port = port;
	}
	
	/**
	 * Get Protocol for communication
	 */
	public String getProtocol()
	{
		return conn_protocol;
	}
	
	/**
	 * Set the Protocol for communication
	 */
	public void setProtocol(String protocol)
	{
		conn_protocol = protocol;
	}
	
	/**
	 * Get the Agent Controller Type 
	 */
	public boolean isAgentControllerNew()
	{
		return this._agentControllerNew;
	}
	
	/**
	 * Set the Agent Controller Type
	 */
	private void setAgentControllerNew(boolean newAC)
	{
		this._agentControllerNew = newAC;
	}

	/**
	 * Set the socket timeout
	 * @param timeout
	 */
	public void setSoTimeout(int timeout) {
		_soTimeout = timeout;
	}
}
