/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *
 * $Id: IConsole.java,v 1.3 2007/03/08 17:26:22 jkubasta Exp $ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.client.core;


/**
 * Console interface for processes launched by the client
 *
 * @since tptp 1.0 (no change)
 *  
 */

public interface IConsole {
	public final static int STDIN = 0;
	public final static int STDOUT = 1;
	public final static int STDERR = 2;

	/**
	 * Set the Data Processor for reading the Console data.	
	 * @param processor org.eclipse.hyades.internal.execution.local.common.DataProcessor
	 */
	public void setDataProcessor(IDataProcessor processor) ;

	/**
	 * Set the Data Processor for reading the Console data.	
	 * @param processor org.eclipse.hyades.internal.execution.local.common.DataProcessor
	 * @param stream
	 */
	public void setDataProcessor(IDataProcessor processor, int stream) ;


	/**
	 * Get the Data Processor of the Console
	 */
	public IDataProcessor getDataProcessor() ;

	/**
	 * Get the Data Processor of the Console for the stream
	 * @param stream
	 */
	public IDataProcessor getDataProcessor(int stream) ;

	/**
	 * Write to the Console.
	 * @param data java.lang.String
	 */
	public void write(String data) ;

	/** 
	 * Close this console 
	 */
	public void close() ;

}
