/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *
 * $Id: IDataProcessor.java,v 1.6 2005/10/19 17:08:13 gnagarajan Exp $ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.client.core;



/**
 * This interface defines the methods to be implemented by clients receiving 
 * data from agents. 
 *
 * @since tptp 1.0 (no change)
 * 
 */


public interface  IDataProcessor {
	/**
	 * This method is invoked when data is received over the data channel
	 * @param buffer byte[]
	 * @param length int
	 * @param peer java.net.InetAddress
	 */
	void incomingData(byte[] buffer, int length, java.net.InetAddress peer);
	/**
	 * This method is invoked when data is received over the data channel
	 * @param buffer char[]
	 * @param length int
	 * @param peer java.net.InetAddress
	 */
	void incomingData(char[] buffer, int length, java.net.InetAddress peer);
	/**
	 * This method is invoked when data received over the data channel
	 * is invalid.
	 * @param data byte[]
	 * @param length int
	 * @param peer java.net.InetAddress
	 */
	void invalidDataType(byte[] data, int length, java.net.InetAddress peer);
	/**
	 * This method is invoked when there is no data to be recieved over
	 * the data channel. Client Data Processors can implementa this to 
	 * perform some other activity while it is waiting for data. 
	 * Creation date: (10/3/00 5:54:46 PM)
	 */
	void waitingForData();
}
