/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFileTransferManager.java,v 1.3 2007/03/20 13:49:32 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.execution.client.core;

import java.io.IOException;


/**
 * @author Giridhar.S
 *
 * The interface implemented by classes which provide methods for performing file transfer.
 *
 */
public interface IFileTransferManager {
	public final static int FILE_TRANSFER_OK = 0;
	public final static int FILE_TRANSFER_ERROR = 1;
	public final static int FILE_NOT_FOUND = 2;
	public final static int FILE_READ_ERROR = 3;
	public final static int FILE_CREATE_ERROR = 4;
	
	/**
	 * Method to request Agent Controller to send the named file.
	 * @param localName - where to put it on the client side.
	 * @param remoteName - remote file name
	 *
	 */
	public int getFile (String localName, String remoteName) throws IOException;

	/**
	 * Method to send a file to the Agent Controller machine.
	 * @param localName - where to find the file.
	 * @param remoteName -  where to put the file.
	 **/
	public int putFile (String localName, String remoteName) throws IOException;

	/**
	 * Method to delete the named file
	 * @param absFileName - name of the file.
	 */
	public void deleteFile (String absFileName)  throws IOException;

}
