/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: INode.java,v 1.3 2005/10/07 22:05:50 vnaikawadi Exp $
 *
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.tptp.platform.execution.client.core;

import java.net.InetAddress;
import java.security.Principal;
import java.util.Enumeration;

import org.eclipse.tptp.platform.execution.security.ISecureClientParameters;
//import org.eclipse.tptp.platform.client.core.internal.commands.SetNVPairCommand;
import org.eclipse.tptp.platform.execution.exceptions.LoginFailedException;
import org.eclipse.tptp.platform.execution.exceptions.SecureConnectionRequiredException;
import org.eclipse.tptp.platform.execution.exceptions.UntrustedAgentControllerException;
//import org.eclipse.tptp.platform.execution.exceptions.InactiveProcessException;
//import org.eclipse.tptp.platform.execution.exceptions.NotConnectedException;
import org.eclipse.tptp.platform.execution.exceptions.AgentControllerUnavailableException;
import org.eclipse.tptp.platform.execution.security.User;


/**
 * Node interface - Represents the target machine.
 *  
 */
public interface INode {


    /**
     * Enumerate all the properties on this node.
     */
    //SetNVPairCommand[] getPropertyValues(String name, String type)
    //        throws NotConnectedException;

    /**
     * Retrieve the InetAddress for this Node.
     */
    InetAddress getInetAddress();

    /**
     * Retrives all the InetAddresses for this Node.
     */
    InetAddress[] getAllInetAddresses();

    /**
     * Retrieve the host name for this Node.
     */
    String getName();

    /**
     * Connects to the Agent Controller running on the target machine and returns the instance of Agent Controller.
     * It takes ConnectionInfo object that defines the connection parameters like port number, communication protocol
     * to be used (HTTP, SOCKET, etc.). An instance of org.eclipse.tptp.platform.execution.security.SecureConnectionInfo 
     * can be passed to create a secured connection.
     * <B>Secure Connection not implemented in TPTP 4.1</B>
     */
    IAgentController connect(ConnectionInfo connInfo) throws AgentControllerUnavailableException,
            SecureConnectionRequiredException,
            UntrustedAgentControllerException, LoginFailedException;
    
	
	
	/*
	 * Connection to AC and authenticate the user 
	 */
	   IAgentController connect(ConnectionInfo connInfo, User user) throws AgentControllerUnavailableException,
       SecureConnectionRequiredException,
       UntrustedAgentControllerException, LoginFailedException;    

    /** Returns the Agent Controller instance connected at the specified port */
    IAgentController getAgentController(int port);

}

