/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Guru Nagarajan,Intel - Initial API and implementation
 *
 * $Id: IProcess.java,v 1.18 2007/11/23 07:45:50 ialelekov Exp $ 
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.client.core;

import java.util.* ;

import org.eclipse.tptp.platform.execution.client.agent.*;
import org.eclipse.tptp.platform.execution.client.core.internal.IProcessListener;
import org.eclipse.tptp.platform.execution.client.core.internal.ProcessInfo;
import org.eclipse.tptp.platform.execution.exceptions.*;
import org.eclipse.tptp.platform.execution.util.Variable;
/**
* IProcess is the interface providing the client with 
* the capability to launch, validate and kill a target process    
* @since tptp 1.0 (no change)
*/
public interface IProcess {
    /**
     * Launch a process 
     * @throws ProcessActiveException
     * @throws NotConnectedException
     * @throws NoSuchApplicationException
     */
    public void launch() throws ProcessActiveException, NotConnectedException, NoSuchApplicationException, InactiveAgentException, TimeoutException;
  
    /**
     * Kills this process if it is active.
     */
    public void kill() throws InactiveProcessException, NotConnectedException, InactiveAgentException;

    /**
     * Provides an Enumeration of all the Agents associated
     * with this Process instance.
     * @deprecated since TPTP 4.0
     */
     //public Enumeration listAgents();

      /**
       * Adds a ProcessListener to this Process instance.
       * @see org.eclipse.tptp.platform.execution.client.core.IProcessListener
       */
      //public void addEventListener(String interfaceID, ICommandHandler listener);
      /**
       * Removes a ProcessListener from this Process instance.
       * @see org.eclipse.tptp.platform.execution.client.core.IProcessListener
       */
      //public void removeEventListener(String interfaceID, ICommandHandler listener);
      /**
       * Retrieves the Node that this Process instance
       * is associated with.
       * @see org.eclipse.tptp.platform.execution.client.core.INode
       * @deprecated since TPTP 4.0
       */
       //public INode getNode() throws InactiveProcessException;

      /**
       * Save a user friendly name so that it can be retrieved later via Process#getName()
       */

       public void setName(String name);
       /**
        * Provided for TPTP 3.x compatibility
        * @deprecated
        * @param name
        * @return IAgent
        */
       //public IAgent getAgent(String name);
      /**
       * Retrieves the name of this process as provided
       * by Process#setName()
       */
       public String getName();
      /**
       * Retrieves the uuid of this process if it is known, null otherwise.
       */
       public String getUUID();            
      /**
       * Set the exectauble name for this process.
       */
       public void setExecutable(String exe) throws ProcessActiveException;
      /**
       * Get the exectable name for this process.
       */
       public String getExecutable();

      /**
       * Retrieve the process ID (pid) for this process
       */
        public long getProcessId() throws InactiveProcessException;
      /**
       * Set the Process Id
       */
        public void setProcessId(long processId);
           
       /**
        * Check if the Process is Active
        */
        public boolean isActive();

        /**
         * Retrieves the console of this Process instance.
         */
       public IConsole getConsole();
         /**
          * Set an environment variable to this process.
          */
       public void setEnvironmentVariable(String name, String value) throws ProcessActiveException;
          /**
           * Prepends an environment variable to this process.
           */
       public void prependEnvironmentVariable(String name, String value) throws ProcessActiveException;

          /**
            * Apppends an environment variable to this process.
            */
        public void appendEnvironmentVariable(String name, String value) throws ProcessActiveException;

           /**
            * Retrieves an environment variable from this process.
            * @return the environment variable with the specified name attribute if it exists, null otherwise.
            */
       public Variable getEnvironmentVariable(String name);

           /**
            * Removes an environment variable from this process.
            */
       public void removeEnvironmentVariable(String name) throws ProcessActiveException;
           /**
            * Provides an enumeration of each Variabe comprising
            * the entire environment of this process.
            * @see Variable
            */

           public Enumeration getEnvironment();

           /**
            * Prepend the parameters for this process
            */

           public void prependParameter(String parameter) throws ProcessActiveException;

           /**
            * Append the parameters for this process
            */

           public void appendParameter(String parameter) throws ProcessActiveException;

           /**
            * Set the parameter for this process
            */
           public void setParameter(String parameter) throws ProcessActiveException;
           /**
            * Retrieves the parameters of the process.
            */
           public String getParameter();

           
           public String getLocation();
           
           /**
            * Set's the home directory of the process.
            */
           public void setLocation(String location) throws ProcessActiveException;

           /**
            * Get the Process Launch Info
            */
           public ProcessInfo getProcessInfo();

           /**
            * Set the Process Launch Info
            */
           //public void setProcessInfo(ProcessInfo pInfo);
           /**
            * Set the cient source Id
            * @deprecated
            * @param clientSrcID
            */
           //public void setSource(int clientSrcID);
           /**
            * Validate the process to be launched
            * @return boolean
            * @throws NotConnectedException
            */
           public boolean validateProcessToLaunch() throws NotConnectedException, InactiveAgentException;
		   
           /**
            * Add a Process Listener
            * @return        
            */
           public void addProcessListener(IProcessListener listener);
           
           /**
            * Return the Process Listeners associated with the Process
            * @return        
            */
           public Vector getProcessListener();
           /**
            * Get the exit code for this process.
            * @return        
            */
           public int getExitCode();	/* Bug 167208 */
           
           /* This has to be modified to return multiple agents or to address the 
            * unbound agents scenario */
           /**
            * Get the agent associated with this process
            * @return
            */
           public IAgent getAgent();
           
           /* This has to be modified to return multiple agents or to address the 
            * unbound agents scenario */
           /**
            * Set the agent associated with this process
            * @return
            */
           public void setAgent(IAgent agent);
}

