/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NodeFactory.java,v 1.6 2007/09/05 00:09:21 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.tptp.platform.execution.client.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;

import org.eclipse.tptp.platform.execution.client.core.internal.*;
import org.eclipse.tptp.platform.execution.exceptions.DuplicateUserException;
import org.eclipse.tptp.platform.execution.security.User;

/* COMPLETE and UNTESTED */


/**
 * 
 * A factory object for creating Nodes.  Nodes can be specified by either name
 * or InetAddress.  Each Node is treated as a singleton and
 * attempts to create a Node that already exists will return
 * the same Node instance that already existed.
 *
 * @since tptp 1.0 (no change)
 *
 */
public class NodeFactory {
	
	private static final int INITIAL_SERVERS=16;
	private static INode[] _servers = new NodeImpl[INITIAL_SERVERS];

	static {
		try {
			//System.out.println("In static block");
			//_servers[0]=createNode(InetAddress.getLocalHost());
			//System.out.println("");
		}
		//catch(UnknownHostException e) {
			/* We ignore this here and throw the error
			   when getLocalHost is called later.
			*/
		//}
		catch(Exception e) {
			System.out.println("NodeFactory static block exception - "+ e);
		}
	}

	
	/**
	 * Create a Node for the suplied hostname.  Nodes are
	 * are intended to be singletons in this application so
	 * if the Node exists it will be returned.
	 */
	public static INode createNode(String hostname) throws UnknownHostException{
		try {
			//return createNode(hostname, null);
			INode result=null;
			result = containsNode(hostname);
			//System.out.println("In createNode");
			if(result==null) {
				InetAddress addr=InetAddress.getByName(hostname);
				return addNode(hostname, addr, null);
			}
			throw new DuplicateUserException();			
		}
		catch(DuplicateUserException e) {
			return containsNode(hostname);
		}

	}



	/**
	 * Create a Node for the suplied InetAddress.  Nodes are
	 * are intended to be singletons in this application so
	 * if the Node exists it will be returned.
	 */
	public static INode createNode(InetAddress address) throws UnknownHostException {
		String hostname = address.getHostName();
		INode node = containsNode(hostname);
		if (node != null) return node;
		
		return addNode(hostname, address, null);
	}


	/**
	 * Returns the node that represents the local host.
	 * @deprecated - use getLocalHost(User user)
	 */
	public static INode getLocalHost() throws UnknownHostException {
		/* The localhost is always in the first slot of the servers table */
		if(_servers[0]==null) {
			throw new UnknownHostException();
		}
		return _servers[0];
	}



	
	private static INode addNode(String name, InetAddress addr, Principal principal)
	{
		if(name.equals("localhost")) {
			try {
				name=InetAddress.getLocalHost().getHostName();
				InetAddress[] addrs=InetAddress.getAllByName(name);
				addr=addrs[0];
			}
			catch(UnknownHostException e) {
				/* We can ignore this */
				System.out.println("Exception creating the node: " + e);
			}
		}
	
		synchronized(_servers) {
			/* Look for the first empty slot */
			for(int i=0; i<_servers.length; i++) {
				if(_servers[i]==null) {
					_servers[i]=new NodeImpl(name, addr);
					
					/* Currently we know how to deal with applications and users */
					//if(principal instanceof User) {
					//	((NodeImpl)_servers[i]).setUser((User)principal);
					//}
					//else if(principal instanceof Application) {
					//	((NodeImpl)_servers[i]).setApplication((Application)principal);
					//}
					return _servers[i];
				}
			}
			/* The table is full, increase it's size. */
			INode[] oldEntries=_servers;
			_servers= new NodeImpl[oldEntries.length+1];
			for(int i=0; i<oldEntries.length; i++) {
				_servers[i]=oldEntries[i];
			}
			_servers[oldEntries.length]=new NodeImpl(name, addr);
			return _servers[oldEntries.length];
		}
	}
	
	private static INode containsNode(String name) {
		synchronized(_servers) {
			// If this is "localhost" try and resolve its real name first
			if(name.equals("localhost")) {
				try {
					name=InetAddress.getLocalHost().getHostName();
				}
				catch(UnknownHostException e) {
					// We can ignore this 
				}
			}
			InetAddress[] addresses=null;
			try {
				addresses=InetAddress.getAllByName(name);

				addresses=InetAddress.getAllByName(addresses[0].getHostName());
			}
			catch(UnknownHostException e) {
				return null;
			}

			for(int i=0; i<_servers.length; i++) {
				if(_servers[i]!=null) {
					for(int k=0; k<addresses.length; k++) {
						InetAddress temp=_servers[i].getInetAddress();
						if(addresses[k].equals(temp)) {
							//if(principal==null) {
							//	return _servers[i];
							//}
							//else if(principal instanceof User && _servers[i].getUser()!=null) {
							//	if(principal.getName().equals(_servers[i].getUser().getName())) {
							//		return _servers[i];
							//	}
							//}
							//else if(principal instanceof IApplication && _servers[i].getApplication()!=null) {
							//	if(principal.getName().equals(_servers[i].getApplication().getName())) {
							//		return _servers[i];
							//	}
							//}
						}
					}
				}
			}
		}
		return null;
	}

	/**
	 * Searches the Node list based upon the InetAddress.
	 * @return the Node if it exists, null otherwise.
	 */
	public static INode getNode(InetAddress addr) {
		//return getNode(addr, null);
		return containsNode(addr.getHostName());
	}
}
