/*******************************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Igor Alelekov, Intel - initial API and implementation
 *    
 * $Id: ConnectionFactory.java,v 1.3 2007/09/06 11:38:49 jkubasta Exp $
 *
 *******************************************************************************/ 

package org.eclipse.tptp.platform.execution.client.core.internal;

import java.io.IOException;

import org.eclipse.tptp.platform.execution.client.core.ConnectionInfo;
import org.eclipse.tptp.platform.execution.client.core.INode;
import org.eclipse.tptp.platform.execution.exceptions.LoginFailedException;
import org.eclipse.tptp.platform.execution.exceptions.NotConnectedException;
import org.eclipse.tptp.platform.execution.exceptions.ReconnectRequestedException;
import org.eclipse.tptp.platform.execution.exceptions.SecureConnectionRequiredException;
import org.eclipse.tptp.platform.execution.exceptions.UntrustedAgentControllerException;

public class ConnectionFactory {
	public static IConnection createConnection (INode node, ConnectionInfo conInfo) throws LoginFailedException, 
		UntrustedAgentControllerException, IOException, ReconnectRequestedException, SecureConnectionRequiredException,
		NotConnectedException {
		
		ConnectionImpl con = null;
		boolean securityRequired = false;

		try {
			con = new ConnectionImpl();
			con.connect(node, conInfo);
		} catch (SecureConnectionRequiredException e) {
			securityRequired = true;
		}
	
		if (!securityRequired) return con;	// insecure connection
		
		SecureConnectionImpl secCon = new SecureConnectionImpl ();
			
		if (!secCon.connect(node, con)) {
			secCon.close();
			secCon = null;
		}		
			
		return secCon;
	}
}
