/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - initial API and implementation
 *    IBM - Hyades/TPTP 3.0 - Initial Java API and implementation
 *
 * $Id$
 *
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.client.core.internal;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;

import org.eclipse.tptp.platform.execution.client.core.*;
import org.eclipse.tptp.platform.execution.client.core.internal.ContextMapper.ContextMap;
import org.eclipse.tptp.platform.execution.util.*;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.DimeHeader;

public class ConsoleDataProcessor implements IDataProcessorWithDime 
{
	protected final static int MAPPING_INCREMENT =10;

	protected ContextMap[] _map=new ContextMap[MAPPING_INCREMENT];
	protected int _mappingCount=0;
	protected int _maxMappingCount=0;

	class ContextMap {
		public long _pid=0;
		public IDataProcessor _processor=null;
		public IDataProcessor stderrProcessor=null;
		public boolean _dirty=false;
	}

	public ConsoleDataProcessor() {
		super();
	}

	public void addDataProcessor(long pid, IDataProcessor processor) {
		addDataProcessor (pid, processor, null);
	}
	
	public void addDataProcessor(long pid, IDataProcessor processor, IDataProcessor stderrProcessor) {
		synchronized(_map) {
			if(_maxMappingCount == _map.length) {
				increaseContextmappingCapacity();
			}
			//System.out.println("Pid = "+pid);
			for(int i=_mappingCount; i>=0; i--) {
				if(_map[i]==null) {
					_mappingCount++;
					_maxMappingCount++;
					_map[i]=new ContextMap();
					_map[i]._pid=pid;
					_map[i]._processor=processor;
					_map[i].stderrProcessor=stderrProcessor;
					_map[i]._dirty=true;
					return;
				}
				else if(!_map[i]._dirty) {
					_mappingCount++;
					_map[i]._pid=pid;
					_map[i]._processor=processor;
					_map[i].stderrProcessor=stderrProcessor;
					_map[i]._dirty=true;
					return;
				}
			}
		}
	}

	public IDataProcessor getProcessor(long pid) {
		return getProcessor (pid, IConsole.STDOUT);
	}

	public IDataProcessor getProcessor(long pid, int stream) {
		IDataProcessor ch=null;
		synchronized (_map) {
			for(int i=_maxMappingCount-1; i>=0; i--) {
				if(_map[i]==null) {
					/* This should never happen */
					break;
				}
				if(_map[i]._pid==pid && _map[i]._dirty==true ) {
					if (stream == ConsoleImpl.STDOUT) {
						ch=_map[i]._processor;
					}
					else if (stream == ConsoleImpl.STDERR) {
						ch=_map[i].stderrProcessor;
					}
						
					break;
				}
			}
		}
		return ch;
	}

	protected void increaseContextmappingCapacity() {
		synchronized(_map) {
			ContextMap[] newMapper=new ContextMap[_maxMappingCount+MAPPING_INCREMENT];
			for(int i=0; i<_maxMappingCount; i++) {
				newMapper[i]=_map[i];
			}
			_map=newMapper;
			newMapper=null;
		}
	}

	public void removeContext(long pid) {
		synchronized (_map) {
			for(int i=_maxMappingCount-1; i>=0; i--) {
				if(_map[i]._pid==pid && _map[i]._dirty==true ) {
					_mappingCount--;
					_map[i]._dirty=false;
					_map[i]._processor=null;
					_map[i].stderrProcessor=null;
					break;
				}
			}
		}
	}
	public void incomingData(byte[] buffer, int length, java.net.InetAddress peer)
	{
		System.out.println("Buffer Console Output  DO NOTHING HERE" + new String(buffer));
	}
	
	public void incomingData(char[] buffer, int length, java.net.InetAddress peer){}
	
	public void invalidDataType(byte[] data, int length, java.net.InetAddress peer){}
	
	public void waitingForData(){}
	/**
	 * Get the processID
	 */
	public static long getTPTPConsoleProcessId(byte[] buffer, int pid_length) 
	{
		if(buffer.length < pid_length)
		{	return -1;}
//		byte[] pbyte = new byte[pid_length-1];
//		System.arraycopy(buffer,Constants.DIME_HEADER_LEN,pbyte,0,pid_length-1);
		//Now that you have the Console part of the Header containing the PID - it also contains the 
		//prefix in this case TPTP_STDOUT: prefix = 'O' ;
		
//		return Long.parseLong((new String(pbyte)).substring(1),10);
		return Long.parseLong(new String(buffer, Constants.DIME_HEADER_LEN+1, pid_length-2),10);
	}

	public static int getTPTPConsoleStream(byte[] buffer) {
		int stream = -1;
		if (buffer != null && buffer.length > Constants.DIME_HEADER_LEN) {
			switch ((char) buffer[Constants.DIME_HEADER_LEN]) {
			case Constants.DIME_TPTP_STDOUT:  
				stream = ConsoleImpl.STDOUT;
				break;
			case Constants.DIME_TPTP_STDERR:  
				stream = ConsoleImpl.STDERR;
				break;
			}
		}
		
		return stream;
	}
	
	/**
	 * Get the Data
	 */
	public static String getTPTPConsoleData(byte[] buffer, int length) 
	{
		return new String(buffer, 0, length);
	}
	
	public void incomingData(byte[] buffer, int length, InetAddress peer, byte[] dimeHeader)
	{
		DimeHeader dimeHeaderObj = DimeHeader.getDIMEHeader(dimeHeader);
		long pid = getTPTPConsoleProcessId(dimeHeader, dimeHeaderObj.getIDLength());
		int stream = getTPTPConsoleStream(dimeHeader);
	
		IDataProcessor cp = getProcessor(pid, stream);
		if (cp == null && stream != IConsole.STDOUT) cp = getProcessor(pid, IConsole.STDOUT);  
		
		if (cp != null) { 
//			cp.incomingData(buffer, length, peer);
			cp.incomingData(getTPTPConsoleData(buffer,length).getBytes(), length, peer);
		}
}
	
	public void incomingData(char[] buffer, int length, InetAddress peer, char[] dimeHeader)
	{
		System.out.println(" Incomming Data Buffer -- DO NOTHING  "+new String(buffer));
	}
}


