/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * 		Guru Nagarajan, Intel - initial API and implementation   
 * 		IBM Corporation - Initial API and implementation
 * 	  
 * $Id$ 
 *******************************************************************************/
package org.eclipse.tptp.platform.execution.client.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.IConsole;
import org.eclipse.tptp.platform.execution.client.core.IDataProcessor;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.DimeHeader;

/**
 * @author gnagaraj
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ConsoleImpl extends Thread implements IConsole, Constants {

	//ServerSocket used for TPTP 3.x
	protected ServerSocket _sock = null; /* 9707 */
	//DataProcessor used by both TPTP 3.x and 4.x
	protected IDataProcessor _processor=null;
	protected IDataProcessor stderrProcessor=null;
	protected long _ip=0;
	protected long _port=0;
	private boolean _started=false;
	private boolean _valid=true;
	private Socket _activeConnection=null;	
	protected IAgentController 	_ac	= null; 
	protected int	_dataConnectionId = -1;
	protected long	_processId = -1;
	protected boolean TPTP_AC = true;
	/**
	 * Console constructor comment.
	 */
	public ConsoleImpl() {
		super();
		/* Don't block the VM from exiting */
		this.setName("Console"); /* 9707 */
		this.setDaemon(true);
	}
	/**
	 * Console constructor comment.
	 * @param name java.lang.String
	 */
	public ConsoleImpl(String name) 
	{
		super(name);
		/* Don't block the VM from exiting */
		this.setDaemon(true);
	}
	/**
	 * Console constructor comment.
	 * @param group java.lang.ThreadGroup
	 * @param name java.lang.String
	 */
	public ConsoleImpl(ThreadGroup group, String name) {
		super(group, name);
		/* Don't block the VM from exiting */
		this.setDaemon(true);
	}	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IConsole#setDataProcessor(org.eclipse.tptp.platform.execution.core.IDataProcessor)
	 */
	public void setProcessID(long processID) {		
		this._processId=processID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IConsole#getDataProcessor()
	 */
	public long getProcessID() 
	{
		return this._processId;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IConsole#setDataProcessor(org.eclipse.tptp.platform.execution.core.IDataProcessor)
	 */
	public void setDataProcessor(IDataProcessor processor) {		
		this._processor=processor;
	}

	public void setDataProcessor(IDataProcessor processor, int stream) {
		switch (stream) {
		case STDOUT:
			this._processor = processor;
			break;
		case STDERR:
			this.stderrProcessor = processor;
			break;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IConsole#getDataProcessor()
	 */
	public IDataProcessor getDataProcessor() 
	{
		return _processor;
	}
	
	public IDataProcessor getDataProcessor(int stream) {
		IDataProcessor dp;
		
		switch (stream) {
		case STDOUT:
			dp = _processor;
			break;
		case STDERR:
			dp = stderrProcessor;
			break;
		default:
			dp = null;
			break;
		}
		
		return dp;
	}
	
	public void setAC(IAgentController ac)
	{
		this._ac = ac;
	}
	public IAgentController getAC()
	{
		return this._ac;
	}
	
	
	public void setTPTPAC(boolean tptp_ac)
	{
		this.TPTP_AC = tptp_ac;
	}
	
	public int getDataConnectionID() {
		return this._dataConnectionId;
	}
	
	public void setDataConnectionID(int dataConnID)
	{
		this._dataConnectionId = dataConnID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IConsole#write(java.lang.String)
	 */
	public void write(String data) 
	{
		if(TPTP_AC)
		{
			try
			{
				if (data != null)
				{
					/*
					char[] consoleData = DimeHeader.writeConsoleData(data.toCharArray(),this.getProcessID(),Constants.DIME_TPTP_STDIN);
					byte[] bytearr = new byte[1024];
					for(int i = 0; i < consoleData.length;i++)
					{
					    bytearr[i] = (byte)consoleData[i];
					}*/
 
					// We don't need to pad the console data that we send to the agent controller through the data channel.
					// (bug 234596)
					byte[] bytearr = data.getBytes();
					((AgentController)this._ac).sendData(this._dataConnectionId, bytearr, bytearr.length);
				}
			}
			catch(Exception e){e.printStackTrace();}
		}
			
		if(!TPTP_AC)
		{
			if(_activeConnection!=null) 
			{
				try {
						_activeConnection.getOutputStream().write(data.getBytes("UTF-8")); // Bug 73074
					}
				catch(Exception e) 
				{
				}
			}
		}
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (2/19/01 5:39:25 PM)
	 */
	
	public void start() {
		/* We need to wait until the server is fully up */
		synchronized(this) {
			_valid=true;
			super.start();
			do {
				try {
					this.wait();
				}
				catch(InterruptedException e) {
				}
			}while(!_started);
		}	
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IConsole#close()
	 */
	public void close() {
		_valid=false;
	}
	
	
	/**
	 * Insert the method's description here.
	 * Creation date: (2/19/01 2:43:25 PM)
	 */
	public void run() {
		byte[] buffer=new byte[1024];
		short port=0/*DATA_PORT_NUM_CLIENT*/;
		boolean started=false;
		boolean complete;

		/* Start the server */
		while(!started) {
			try {
				started=true;
				_sock=new ServerSocket(port, 1);
			}
			catch(Exception e) {
				port++;
				started=false;
			}
		}

		/* Store the address information of this console */
		_port=_sock.getLocalPort();
		try {
			byte[] bytes = InetAddress.getLocalHost().getAddress();
			_ip=(long)(bytes[3]<<24    & 0xff000000)
					| (long)(bytes[2]<<16 & 0x00ff0000)
					| (long)(bytes[1]<<8  & 0x0000ff00)
					| (long)(bytes[0]     & 0x000000ff);
		}
		catch(UnknownHostException e) {
			/* Shouldn't happen as we are looking up the localhost */
		}

		/* Inform the start method we are up */
		synchronized(this) {
			_started=true;
			this.notify();
		}

		while(_valid) {
			InputStream is=null;
			_activeConnection=null;
			try {
				_activeConnection=_sock.accept();
				is=_activeConnection.getInputStream();
				_activeConnection.setSoTimeout(1000);
				complete=false;
			}
			catch(Exception e) {
				/* The server socket is toast, return */
				return;
			}
			while(!complete) {
				int length=0;
				try {
					length=is.read(buffer);
				}
				catch(InterruptedIOException e) {
					/* Read timeout, don't want to wait too long */
					if(_processor != null) {
						_processor.waitingForData();
					}
				}
				catch(IOException e) {
					try {
						_activeConnection.close();
					}
					catch(IOException e1) {
					}
					complete=true;
				}
					
				/* Is the connection closed? */
				if(length<0) {
					try {
						_activeConnection.close();
					}
					catch(IOException e) {
					}
					complete=true;
				}
				else if(length > 0) {
					if(_processor != null) {
						_processor.incomingData(buffer, length, _activeConnection.getInetAddress());
					}
				}
				
				/* Have we been asked to stop. */
				if(!_valid) {
					try {
							_activeConnection.close();
						}
					catch(IOException e1) 
					{
					}
					complete=true;	
				}
			}
		}
	}	

}
