/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *    Andy Kaylor, Intel - Removed support for RAC commands
 *
 * $Id$ 
 *******************************************************************************/ 

package org.eclipse.tptp.platform.execution.client.core.internal;

import java.util.Enumeration;
import java.util.Hashtable;

import org.eclipse.tptp.platform.execution.util.*;
import org.eclipse.tptp.platform.execution.util.internal.CommandElement;
import org.eclipse.tptp.platform.execution.util.internal.CommandFragment;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.Message;
import org.eclipse.tptp.platform.execution.util.internal.TPTPMessageUtil;
import org.eclipse.tptp.platform.execution.util.internal.TPTPString;
import org.eclipse.tptp.platform.execution.util.internal.TPTPXMLParse;

/**
 * This class allows commands to be packaged into a single message
 *@provisional
 *@since TPTP 4.0
 */
public class ControlMessage extends Message implements IControlMessage {

	
	ICommandElement[] _entries=null;

	/* The length field */
	long _length;

	/* The authentication key */
	protected TPTPString _key=new TPTPString("");

	
	/**
	 * ControlMessage constructor comment.
	 */
	public ControlMessage() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IControlMessage#appendCommand(org.eclipse.tptp.platform.execution.core.ICommandElement)
	 */
	public void appendCommand(ICommandElement command) {
		if(_entries==null) {
			_entries=new CommandElement[1];
			_entries[0]=command;
			return;
		}
		synchronized(_entries) {
//			if(this.getSize()+command.getSize() >= MAX_MESSAGE_LENGTH)
//				throw new MessageOverflowException();

			ICommandElement[] _oldElements=_entries;
			_entries=new CommandElement[_oldElements.length+1];
			for(int i=0; i<_oldElements.length; i++) {
				_entries[i]=_oldElements[i];
			}
			_entries[_oldElements.length]=command;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IControlMessage#getCommand(int)
	 */
	public ICommandElement getCommand(int offset) {
		return _entries[offset];
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IControlMessage#getCommandCount()
	 */
	public int getCommandCount() {
		int length = 0;
		if (_entries != null)
		{
			length =  _entries.length;
		}		
		return length;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IControlMessage#getKey()
	 */
	public TPTPString getKey() {
		return _key;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IControlMessage#setKey(org.eclipse.tptp.platform.execution.util.TPTPString)
	 */
	public void setKey(TPTPString key) {
		_key = key;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IControlMessage#getLength()
	 */
	public long getLength() {
		return _length;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#getTicket()
	 */
	public long getTicket() {
		// TODO Auto-generated method stub
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#getType()
	 */
	public long getType() {
		// TODO Auto-generated method stub
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#getVersion()
	 */
	public long getVersion() {
		// TODO Auto-generated method stub
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#setTicket(long)
	 */
	public void setTicket(long ticket) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#setVersion(long)
	 */
	public void setVersion(long version) {
		// TODO Auto-generated method stub

	}	

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#getSize()
	 */
	public int getSize() {
		int size=super.getSize();

		/* The length field */
		size+=sizeofLong;
		
		/* The commands */
		/*synchronized(_entries) {*/
		if (_entries != null)
		{
			for(int i=0; i<_entries.length; i++)
				size+=_entries[i].getSize();
		}
			
		return  size;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#readFromBuffer(byte[], int)
	 */
	public int readFromBuffer(byte[] buffer, int offset) 
	{
		int current = 0;
		try
		{
		long messageType = super.getMessageType();
		
		current=super.readFromBuffer(buffer, offset);
		//System.out.println("Current valyue = "+current);
		_length=TPTPMessageUtil.readTPTPLongFromBuffer(buffer, current);
		//System.out.println("Current _Length = "+_length);
		current+=sizeofLong;
		
		int count = 0;
		
		String cmdString = null;
		try
		{
			//System.out.println("---Buffer = "+new String(buffer));
			//System.out.println("--------------------------------");
			//System.out.println("---Length = "+_length);
			//System.out.println("---BufferLength = "+buffer.length);
			//System.out.println("---Current  = "+current);
			Long ll = new Long(_length);
			
			int l = ll.intValue();
			//System.out.println("L after the conversion "+l);
			if(buffer.length < l){
				//System.out.println("---Buffer = "+new String(buffer));
				//System.out.println("LESS THAN Length = "+l);
				return -1;}
			
			try
			{
				//System.out.println("Creating string ");
				cmdString = new String(buffer, current, (int)_length, "UTF-8");
				//System.out.println("The CMDSTRING  Exception block- " + cmdString);
			}
			catch(Exception e){e.printStackTrace();}
		}
		catch(Throwable e)
		{
			e.printStackTrace();
			if(buffer.length <  (int)_length){
				//System.out.println("---Non UTF Buffer = "+new String(buffer));
				//System.out.println("---Non UTF Length = "+_length);
				return -1;}
			cmdString = new String(buffer, current, (int)_length);
			//System.out.println("The CMDSTRING  Exception block- " + cmdString);
		}
		if (cmdString.indexOf("<Cmd") != -1)
		{
			if (cmdString.indexOf("</Cmd>") != -1)
			{
				int firstIndex = cmdString.indexOf("</Cmd>");
				int lastIndex = cmdString.lastIndexOf("</Cmd>");
				count = lastIndex-firstIndex+1;
				//System.out.println("The received command count " + count);
			}
			else
			{
				return -1;
			}
		}
		else
		{
			//System.out.println("Was the string not created ");
			//return -1;
		}

		if (count != 0)
		{
			_entries=new CommandElement[(int)count];
		}
		if(count == 0){
			//System.out.println("Do we have commandElements  "+count);
			//return -1;
			}
		/* Read in each command */
		for(int i=0; i<count; i++) {
			current = readACCommands(buffer, current, i);
		}
		}catch(Exception e){e.printStackTrace();}
		return current;
	}
	
	private int readACCommands(byte[] buffer, int offset, int commandCount)
	{
		CommandElement command=null;
		int current = offset;
		
		command=new CommandFragment();
		current=((CommandFragment)command).readFromBuffer(buffer, current);
		//System.out.println("Parsing XML");
		if(Constants.TPTP_DEBUG)System.out.println("The AC response " + command.getTag());
		
		String commandStr = new String(((CommandFragment)command).getCommandData());
		if(Constants.TPTP_DEBUG)System.out.println("The command received is - " + commandStr);
		TPTPXMLParse ParseObj = new TPTPXMLParse();
		
		ParseObj.setParser(commandStr);
		
		Enumeration enumer = ParseObj.getHashTable().keys();
		Hashtable CommandHash = ParseObj.getHashTable();
		int ctx = -1;
		int src = -1;
		int dest = -1;
	
		if (CommandHash.containsKey("ctxt"))
		{
			String ctxVal = (String)CommandHash.get("ctxt");
			ctx = Integer.parseInt(ctxVal);
		}
		if(CommandHash.containsKey("src"))
		{ 
			String srcVal = (String)CommandHash.get("src");
			src = Integer.parseInt(srcVal);
		}
		if(CommandHash.containsKey("dest"))
		{ 
			String destVal = (String)CommandHash.get("dest");
			dest = Integer.parseInt(destVal);
		}
		
		command.setContext(ctx);
		command.setDestination(dest);
		command.setSource(src);
		/* Store the command in the array */
		_entries[commandCount]=command;
		
		return current;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IMessage#writeToBuffer(byte[], int)
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current=super.writeToBuffer(buffer, offset);
		if(Constants.TPTP_DEBUG)System.out.println("The message size - " + current);
		int payLoadSize = 0;
		
		if (_entries!=null)
		{
			for(int i=0; i< _entries.length; i++)
			{
				payLoadSize += _entries[i].getSize();
			}
		}
		_length = payLoadSize;
		
		/* Insert the length */
		current=TPTPMessageUtil.writeTPTPLongToBuffer(buffer, current, _length);
		

		if (_entries != null)
		{
			for(int i=0; i<_entries.length; i++) {
				current=_entries[i].writeToBuffer(buffer, current);
			}
		}
		if(Constants.TPTP_DEBUG)System.out.println("The message size - " + current);
		return current;
	}
}
