/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM,Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - initial API and implementation
 *    IBM - Hyades/TPTP 3.0 - Initial Java API and implementation
 *
 * $Id$
 *
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.client.core.internal;


import java.io.File;


public class FileDataMapper {
	protected final static int MAPPING_INCREMENT =10;

	protected ContextMap[] _map=new ContextMap[MAPPING_INCREMENT];
	protected int _mappingCount=0;
	protected int _maxMappingCount=0;

	class ContextMap {
		public String _fileName="";
		public File _fileHandle=null;
		public boolean _dirty=false;
	}

	public FileDataMapper() {
		super();
	}

	public void addContext(String fileName, File fileHandle) {
		synchronized(_map) {
			if(_maxMappingCount == _map.length) {
				increaseContextmappingCapacity();
			}
			//System.out.println("File Name = " + fileName);
			for(int i=_mappingCount; i>=0; i--) {
				if(_map[i]==null) {
					_mappingCount++;
					_maxMappingCount++;
					_map[i]=new ContextMap();
					_map[i]._fileName = fileName;
					_map[i]._fileHandle = fileHandle;
					_map[i]._dirty = true;
					return;
				}
				else if(!_map[i]._dirty) {
					_mappingCount++;
					_map[i]._fileName = fileName;
					_map[i]._fileHandle = fileHandle;
					_map[i]._dirty = true;
					return;
				}
			}
		}
	}

	public File getProcessor(String fileName) {
		File fileHandle=null;
		
		synchronized (_map) {
			for(int i=_maxMappingCount-1; i>=0; i--) {
				if(_map[i]==null) {
					/* This should never happen */
					break;
				}
				if (fileName != null)
				{
					if(fileName.equals(_map[i]._fileName) && _map[i]._dirty==true ) {
						fileHandle=_map[i]._fileHandle;
						break;
					}
				}
			}
		}
		return fileHandle;
	}

	protected void increaseContextmappingCapacity() {
		synchronized(_map) {
			ContextMap[] newMapper=new ContextMap[_maxMappingCount+MAPPING_INCREMENT];
			for(int i=0; i<_maxMappingCount; i++) {
				newMapper[i]=_map[i];
			}
			_map=newMapper;
			newMapper=null;
		}
	}

	public void removeContext(String fileName) {
		if (fileName == null) return;
		
		synchronized (_map) {
			for(int i=_maxMappingCount-1; i>=0; i--) {				
				if(_map[i]._fileName==fileName && _map[i]._dirty==true ) {
					_mappingCount--;
					_map[i]._dirty=false;
					_map[i]._fileHandle=null;
					break;
				}
			}
		}
	}
}
