/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/


package org.eclipse.tptp.platform.execution.client.core.internal;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;

import org.eclipse.tptp.platform.execution.client.core.IFileTransferManager;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.DimeHeader;

import java.io.IOException;
import java.util.HashMap;

public class FileDataProcessor implements IDataProcessorWithDime {
	
	private FileDataMapper _fileNameMapper;
	private HashMap CompletedFilesHash;

	public FileDataProcessor() {
		super();
		// TODO Auto-generated constructor stub
		_fileNameMapper = new FileDataMapper();
		CompletedFilesHash = new HashMap();
	}
	
	public void incomingData(byte[] buffer, int length, InetAddress peer)
	{
		//Do Nothing
	}
	
	/**
	 * Handle the data coming 
	 */
	public void incomingData(byte[] buffer, int length, InetAddress peer, byte[] dimeHeader)
	{
		File fileHandle = null;
		String fileName = null;
		DataOutputStream FileWriteStream = null;
		DimeHeader dimeHeaderObj = DimeHeader.getDIMEHeader(dimeHeader);

		int errorCode = getErrCodeFromHeader(dimeHeader, dimeHeaderObj);

		try
		{
			//System.out.println("The file handle to be written into - " + fileHandle);
			//if (fileHandle != null)
			//{
				//synchronized(this)
				//{
					
					fileName = getFileNameFromHeader(dimeHeader, dimeHeaderObj.getIDLength());
					if (fileName == null) { System.out.println("Error - file name is null"); return; }
					
					//System.out.println("File name is - " + fileName);
					fileHandle = _fileNameMapper.getProcessor(fileName);
					//System.out.println("The file handle is - " + fileHandle);
					if (fileHandle == null) {System.out.println("Invalid File Handle "); return; }

					if (errorCode != IFileTransferManager.FILE_TRANSFER_OK) {
						fileTransferCompleted (fileHandle, errorCode);
						return;
					}
					
					
					if (dimeHeaderObj.getMB())
					{
						//System.out.println("Starting File Transfer for file - " + fileName + "...");
						FileWriteStream = new DataOutputStream(new FileOutputStream(fileName));
					}
					else
					{
						FileWriteStream = new DataOutputStream(new FileOutputStream(fileName, true));
					}
					//System.out.println("Writing the data...");
					FileWriteStream.write(buffer, 0, length);
					//System.out.println("The count - " + count);
					FileWriteStream.flush();
					FileWriteStream.close();
					/* Post the semaphore when we get to the last record */				
					if (dimeHeaderObj.getME()) {
						//System.out.println("The File Transfer for file " + fileName + " is completed.");						;
						fileTransferCompleted (fileHandle, IFileTransferManager.FILE_TRANSFER_OK);
					}
				//}
			//}
		}
		catch(IOException exp)
		{
			System.out.println("FileDataProcessor: Error writing to the file " + exp);
		}
	
	}
	
	private synchronized void fileTransferCompleted (File file, int errorCode) {
		if (file != null) {
			CompletedFilesHash.put(file, new Integer(errorCode));
			notifyAll ();
		}
	}
	
	/**
	 * Handle the data coming 
	 */
	public void incomingData(char[] buffer, int length, InetAddress peer)
	{
		//System.out.println("The FileDataProcessor called.");		
	
	}	
	
	/**
	 * Handle the data coming 
	 */
	public void incomingData(char[] buffer, int length, InetAddress peer, char[] dimeHeader)
	{
		//System.out.println("The FileDataProcessor called.");		
	
	}
	
	/**
	 * Invalid Data Type
	 */
	public void invalidDataType(byte[] data, int length, InetAddress peer)
	{
		
		
	}
	/**
	 * Waiting for data
	 */
	public void waitingForData()
	{
		
		
	}

	
	public void initializeFileTransfer(String fileName, File file)
	{
		_fileNameMapper.addContext(fileName, file);
	}
	

	public synchronized int waitForFileComplete(String fileName)
	{
		File fileHandle = _fileNameMapper.getProcessor(fileName);
		if (fileHandle == null) return IFileTransferManager.FILE_TRANSFER_ERROR;

		Integer completed = null;
		
		try {
			while (true) {
				completed = (Integer) CompletedFilesHash.remove(fileHandle);
				if (completed != null) {
					_fileNameMapper.removeContext(fileName);
					break;
				}
				
				wait();
			}			
		}
		catch(InterruptedException exp)
		{
			System.out.println("FileDataProcessor: Error waiting for file transfer complete " + exp);
		}
		
		return completed.intValue();
	}
	
	
	/**
	 * Get the processID a binary array to the buffer
	 */
	public static String getFileNameFromHeader(byte[] buffer, int fileNameLength) 	
	{
		if (buffer == null || fileNameLength <= 1) return null;
		
		return new String(buffer, Constants.DIME_HEADER_LEN, fileNameLength-1);
	}

	public static int getErrCodeFromHeader(byte[] dime, DimeHeader dimeHeaderObj) 	
	{
		if (dimeHeaderObj.getOptionsLength() <= 0) return IFileTransferManager.FILE_TRANSFER_OK;
		
		int fileNameLen = dimeHeaderObj.getIDLength();
		
		return dime[Constants.DIME_HEADER_LEN + fileNameLen];
	}
}
