/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Guru Nagarajan, Intel Corporation, Modification for TPTP 4.0 
 *
 * $Id$ 
 *******************************************************************************/ 

package org.eclipse.tptp.platform.execution.client.core.internal;

import java.net.InetAddress;

import org.eclipse.tptp.platform.execution.client.core.IFileLocation;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class FileLocationImpl implements IFileLocation {
 private String key;
 private int port;
 private InetAddress addr;
 
 public FileLocationImpl(InetAddress addr, int port, String jobKey) {
  this.addr=addr;
  this.port=port;
  this.key=jobKey;
  
 }
 
 public FileLocationImpl() {
  
 }
 
 /**
  * @see org.eclipse.hyades.execution.core.file.IFileLocation#getInetAddress()
  */
 public InetAddress getInetAddress() {
  return addr;
 }
 
 /**
  * @see org.eclipse.hyades.execution.core.file.IFileLocation#getPort()
  */
 public int getPort() {
  return port;
 }
 
 /**
  * @see org.eclipse.hyades.execution.core.file.IFileLocation#getJobKey()
  */
 public String getJobKey() {
  return key;
 }
 
 public void setInetAddress(InetAddress addr) {
  this.addr=addr;
 }
 
 public void setPort(int port) {
  this.port=port;
 }
 
 public void setJobKey(String key) {
  this.key=key;
 }
 
 
}
