/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Vishnu K Naikawadi, Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/

package org.eclipse.tptp.platform.execution.client.core.internal;

import java.io.IOException;

import org.eclipse.tptp.platform.execution.client.core.*;
import org.eclipse.tptp.platform.execution.exceptions.*;
import org.eclipse.tptp.platform.execution.util.ICommandHandler;



public interface IConnection {

	void sendMessage(IControlMessage msg, ICommandHandler handler) throws IOException;

	void disconnect();

	INode getNode();

	boolean isActive();

	int getPort();
	
	long getNextContextId();

	void connect(INode node, ConnectionInfo connInfo) throws IOException, SecureConnectionRequiredException, LoginFailedException,	UntrustedAgentControllerException, ReconnectRequestedException;
	
	/**
	 * Adds a ConnectionListener to this Connection instance.
	 * @see ConnectionListener
	 */
	void addConnectionListener(IConnectionListener listener);
	
	/**
	 * Removes a ConnectionListener from this Connection instance.
	 * @see ConnectionListener
	 */
	void removeConnectionListener(IConnectionListener listener);
		
	void sendData(int dataConnectionId, byte[] buffer, int bufferLength);

}

