/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.client.core.internal;

import org.eclipse.tptp.platform.execution.util.*;
import org.eclipse.tptp.platform.execution.util.internal.IMessage;
import org.eclipse.tptp.platform.execution.util.internal.TPTPString;

/**
 * Interface for batching commands into a single context 
 */

public interface IControlMessage extends IMessage {


 /** 
  * Append the passed command to the command list 
  */
 public void appendCommand(ICommandElement command) ;

 /** 
  * Get the command at the offset specified 
  */
 public ICommandElement getCommand(int offset);

 /** 
  * Get the command count 
  */
 public int getCommandCount() ;

 /** 
  * Get the Key 
  */
 public TPTPString getKey() ;

 /** 
  * Set the Key 
  */
 public void setKey(TPTPString key) ;

 /** 
  * Get the message length 
  */
 public long getLength() ;

 /** 
  * Get message size 
  */
 public int getSize() ;

 /** 
  * Read from the buffer 
  */
 public int readFromBuffer(byte[] buffer, int offset);

 /** 
  * Write to Buffer 
  */
 public int writeToBuffer(byte[] buffer, int offset);
}
