/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi, Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/


package org.eclipse.tptp.platform.execution.client.core.internal;

import org.eclipse.tptp.platform.execution.client.core.IDataProcessor;

public interface IDataProcessorWithDime extends IDataProcessor {

	/**
	 * This method is invoked when data is received over the data channel
	 * @param buffer byte[]
	 * @param length int
	 * @param peer java.net.InetAddress
	 * @param dimeHeader byte[]
	 */
	void incomingData(byte[] buffer, int length, java.net.InetAddress peer, byte[] dimeHeader);	
	
	void incomingData(char[] buffer, int length, java.net.InetAddress peer, char[] dimeHeader);
}
