/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id$
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.execution.client.core.internal;

import org.eclipse.tptp.platform.execution.client.core.IProcess;

public interface IProcessListener {
	
	/**
	 * Invoked when a process is launched.  The
	 * process parameter contains all the information
	 * regarding the process.
	 */
	void processLaunched(IProcess process);
		
	/**
	 * Invoked when a process that was previously launched
	 * exits.The process parameter contains all the information
	 * regarding the process.
	 */
	void processExited(IProcess process);

}

