/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Vishnu K Naikawadi, Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/

package org.eclipse.tptp.platform.execution.client.core.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Vector;

import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.execution.client.core.*;
import org.eclipse.tptp.platform.execution.util.internal.*;
import org.eclipse.tptp.platform.execution.security.*;
import org.eclipse.tptp.platform.execution.exceptions.*;
import org.eclipse.tptp.platform.iac.administrator.internal.startstop.AutoStartStop;
import org.osgi.framework.Bundle;

public class NodeImpl implements INode {
	protected String _name;
	protected InetAddress[] _addr;
	protected Vector _listeners=new Vector(10);
	//protected IConnection _connection;
	private IAgentController _ac;

	private Object propLock = new Object();

	/* The process table for this node.  The processes will be indexed based upon their PID */
	protected Hashtable _processes=new Hashtable(300);

	public NodeImpl(String name, InetAddress addr) {
		super();
		_name=name;
		try {
			_addr=InetAddress.getAllByName(addr.getHostName());
		}
		catch(Exception e) {}
	}

	public NodeImpl(String name, InetAddress[] addr) {
		super();
		_name=name;
		_addr=addr;
	}


	/**
	 * @see Node#getInetAddress()
	 */
	public InetAddress getInetAddress() {
		if(_addr!=null) {
			return _addr[0];
		}

		return null;
	}

	/**
	 * @see Node#getAllInetAddresses()
	 */
	public InetAddress[] getAllInetAddresses() {
		return _addr;
	}

	/**
	 * @see Node#getName()
	 */
	public String getName() {
		return _name;
	}

	/**
	 * @see Node#isConnected()
	 */
	public boolean isConnected() {
		return _ac != null;
	}

	/**
	 * @see Node#connect()
	 */
	public synchronized IAgentController connect(ConnectionInfo connInfo) throws AgentControllerUnavailableException, SecureConnectionRequiredException, UntrustedAgentControllerException, LoginFailedException
	{
		
		/* NM: Bugzilla 173330: Start IAC */
		
		/* First check to see whether the iac.administrator plugin is available */
		Bundle iacBundle = Platform.getBundle("org.eclipse.tptp.platform.iac.administrator");
		
		if ((iacBundle != null) && (isLocal()))			
			AutoStartStop.startIAC(); 
		
		/* End of bugzilla 173330 */
			
		IConnection _connection = null;
		int tryCount = 0;
		if(_ac == null) {
			do {
				try {
					_connection = ConnectionFactory.createConnection(this, connInfo); 
					if (tryCount == Constants.CONNECT_TIMEOUT_TRY_COUNT) {
						throw new TimeoutException(Constants.TPTP_PLATFORM_EXEC_MSG21);
					}
					tryCount++;
				}
				catch (LoginFailedException e) {
					throw e;
				}
				catch (ReconnectRequestedException e) {
					connInfo.setPort(e.getReconnectPort());
					tryCount = 0;
					_connection=null;
				}
				catch(Exception e) {
					_connection = null;
					if (Constants.TPTP_DEBUG) System.out.println("The NodeIml connect exception - " + e);
					throw new AgentControllerUnavailableException(Constants.TPTP_PLATFORM_EXEC_MSG22 + e.getMessage());
				}
			}
			while(_connection == null);
		}
		
		if(_connection != null) {
			_ac = new AgentController(this, connInfo);
			((AgentController)_ac).setConnection(_connection);
		} 
		
		return _ac;
	}
	
	public synchronized IAgentController connect(ConnectionInfo connInfo, User user) throws AgentControllerUnavailableException, SecureConnectionRequiredException, UntrustedAgentControllerException, LoginFailedException	{
		if (!isConnected()) {
			connect(connInfo);
		}
			
		if (_ac == null) return null;
		
		try {
			_ac.authenticateUser(user);
		} catch (Exception e) {
			e.printStackTrace();
			throw new AgentControllerUnavailableException();
		}

		return _ac;
	}
	
	public IAgentController getAgentController(int port) {
		return _ac;
	}
	
	private boolean isLocal() {
		boolean isLocal = false;

		try {
			InetAddress localAddr = InetAddress.getLocalHost();
			for (int i = 0; i < _addr.length; i++) {
				if (localAddr.equals(_addr[i])) {
					isLocal = true;
				}
			}
		} catch (UnknownHostException e) {
		}

		return isLocal;
	}
	
	public void disconnect() {
		if (_ac != null) { 
			_ac.disconnect();  
			_ac = null; 
		}
	}
}
