/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Guru Nagarajan, Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/
package org.eclipse.tptp.platform.execution.client.core.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.internal.AgentImpl;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.IConsole;
import org.eclipse.tptp.platform.execution.client.core.IDataProcessor;
import org.eclipse.tptp.platform.execution.client.core.INode;
import org.eclipse.tptp.platform.execution.client.core.IProcess;
import org.eclipse.tptp.platform.execution.client.core.internal.commands.GetProcessUUIDCommand;
import org.eclipse.tptp.platform.execution.client.core.internal.commands.LaunchProcessCommand;
import org.eclipse.tptp.platform.execution.exceptions.InactiveAgentException;
import org.eclipse.tptp.platform.execution.exceptions.InactiveProcessException;
import org.eclipse.tptp.platform.execution.exceptions.NoSuchApplicationException;
import org.eclipse.tptp.platform.execution.exceptions.NotConnectedException;
import org.eclipse.tptp.platform.execution.exceptions.NotSupportedException;
import org.eclipse.tptp.platform.execution.exceptions.ProcessActiveException;
import org.eclipse.tptp.platform.execution.exceptions.TimeoutException;
import org.eclipse.tptp.platform.execution.util.ICommandElement;
import org.eclipse.tptp.platform.execution.util.ICommandHandler;
import org.eclipse.tptp.platform.execution.util.TPTPAgentAccess;
import org.eclipse.tptp.platform.execution.util.Variable;
import org.eclipse.tptp.platform.execution.util.internal.CommandFragment;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.TPTPXMLParse;

public class ProcessImpl implements IProcess,IConnectionListener, Runnable {

	//This is the processController AgentID - aka PC ConnectionID
	protected int 		_destID		= -1;
	protected INode 	_node 		= null;
	protected IAgentController 	_ac	= null;
	protected ConsoleImpl 	_console 	= null;
	protected boolean 	_isActive 	= false;
	protected boolean 	_isComplt 	= false;
	protected String  	_UUID 		= null;
	
	protected long 		_processId	= 0;
	protected Vector 	_agents		= new Vector();
	protected Vector 	_listeners	= new Vector();
	protected Vector 	_variables	= new Vector();
	protected int		_srcID		= -1; 
	protected ProcessInfo _processInfo = null;
	protected int 		_consoleDataConnectID = -1;
	protected IDataProcessor _dataProcessor;
	//TPTP_AC version will be replaced 
	protected boolean	TPTP_AC 	= true;
	protected final static String pcAgentName = Constants.PROCCTLR_AGENT_NAME;
	
	protected boolean 	_validApp	= false;
	protected boolean 	_validWorkingDir	= false;
	
	private ProcessEventListener _processListener = null;
	private int exitCode;	/* Bug 167208 */

	private IAgent _agent = null;
	public ProcessImpl(IAgentController ac)
	{
		this._ac = ac;
		this._node = ac.getNode();
		this._console = null;
		_processInfo = new ProcessInfo();
	}

	public ProcessImpl(IAgentController ac, String executable)
	{
		new ProcessImpl(ac,executable,null);
		this._console = null;
	}	
	
	public ProcessImpl(IAgentController ac, String executable, String parameters)
	{
		this._ac = ac;
		this._node = ac.getNode();
		this._console = null;
		_processInfo = new ProcessInfo();
		if (executable != null)
		{
			_processInfo.setExecutable(executable);
		}
		if (parameters != null)
		{
			_processInfo.setParameters(parameters);
		}
	}
	
	public void setAgent(IAgent agent)
	{
		this._agent = agent;
	}
	
	public IAgent getAgent()
	{
		return this._agent;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#launch()
	 */
	public void launch() throws ProcessActiveException, NotConnectedException,NoSuchApplicationException, InactiveAgentException, TimeoutException 
	{
		if(_ac==null){throw new NotConnectedException(Constants.TPTP_PLATFORM_EXEC_MSG23);}		
		if(isActive()){throw new ProcessActiveException(Constants.TPTP_PLATFORM_EXEC_MSG24);}
		if(TPTP_AC)
		{
			try{ this.launchAC(); } 
			catch(ProcessActiveException e){throw e;}
			catch(NotConnectedException e){throw e;}
			catch(NoSuchApplicationException e){throw e;}
			catch(InactiveAgentException  e){throw e;}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#kill(long)
	 */
	
	public void kill() throws InactiveProcessException, NotConnectedException, InactiveAgentException 
	{
		(new Thread(this)).start();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#validateProcessToLaunch()
	 */
	public boolean validateProcessToLaunch() throws NotConnectedException, InactiveAgentException 
	{
		final Object _launcherLock 	= new Object();
		
		final GenericCommandHandler genCmdHandler = new GenericCommandHandler();
		if(this._ac == null){throw new NotConnectedException(Constants.TPTP_PLATFORM_EXEC_MSG27);}
	 	if(TPTP_AC)
		{
	 	 try
		 {
	 	 	if (this._destID == -1)
	 	 	{
	 	 		this._destID = this.getDestID();
	 	 		if(this._destID == -1){throw new InactiveAgentException(Constants.TPTP_PLATFORM_EXEC_MSG28);}
	 	 	}
	 	 	synchronized(_launcherLock) 
			{
	 		   try 
			   { 	
	 		   	 org.eclipse.tptp.platform.execution.client.core.internal.commands.ValProcessToLaunchCommand command= new org.eclipse.tptp.platform.execution.client.core.internal.commands.ValProcessToLaunchCommand(_processInfo.getExecutable(), _processInfo.getWorkingDirectory());
 			
	 		   	((AgentController)_ac).sendCommand(command.buildCommand(), this._destID, new ICommandHandler(){
 				public void incomingCommand(INode node, ICommandElement command)
 				{
 				   genCmdHandler.setCommandElement(command); 
 				}
 				});
	 		   try{_launcherLock.notifyAll();}
			    catch(Exception e){e.printStackTrace();}	
			   }
 			   catch(Exception e){e.printStackTrace();}
			} //synchronized
	 	 	synchronized(_launcherLock)
		 	{
 				int processLauchTimeOut = 0;
		 	    while(genCmdHandler.getCommandElement() == null )
		 	    {
		 	        try
		 	        {		 	        	
		 	        	_launcherLock.wait(Constants.TIMEOUT_PERIOD);
		 	        	if (processLauchTimeOut == Constants.PROCESS_LAUNCH_TIMEOUT_TRY_COUNT)
		 	        	{
		 	        		throw new TimeoutException(Constants.TPTP_PLATFORM_EXEC_MSG33);		
		 	        	}
		 	        	processLauchTimeOut++;
		 	        	if (Constants.TPTP_DEBUG) System.out.println("The Process Launch Timeout count" + processLauchTimeOut);
		 	        }
		 	        catch(TimeoutException e)
		 	        {
		 	        	_launcherLock.notifyAll();
		 	        	//e.printStackTrace();
		 	        	break;
		 	        }
		 	        catch(Exception e)
		 	        {
		 	        	_launcherLock.notifyAll();
		 	        	e.printStackTrace();
		 	        	break;
		 	        }
		 	    }
		 	}
	 	 	if (genCmdHandler.getCommandElement() == null) {return false;}
	 	 	String commandStr = ((CommandFragment)genCmdHandler.getCommandElement()).getCommandData();
			TPTPXMLParse ParseObj = new TPTPXMLParse();
			ParseObj.setParser(commandStr);
			Hashtable CommandHash = ParseObj.getHashTable();
			if(CommandHash.containsKey("validApp") || CommandHash.containsKey("validWorkingDir"))
			{ 	
				String validAppRes = new String();
				if((String)CommandHash.get("validApp")!= null)validAppRes = (String)CommandHash.get("validApp");
				String validWorkingDirRes = new String();;
				if((String)CommandHash.get("validWorkingDir")!= null) validWorkingDirRes = (String)CommandHash.get("validWorkingDir");
				
				if(validAppRes.equals("1")){_validApp = true;}
				if(validWorkingDirRes.equals("1")){ _validWorkingDir = true;}
			}		
 			if(ParseObj.getHashTable().containsKey("TPTP_Error"))
 			{
 				String srciid = (String)ParseObj.getHashTable().get("iid");
 				String errCode= (String)ParseObj.getHashTable().get("ErrCode");
 				String errInfo= (String)ParseObj.getHashTable().get("ErrInfo");
 				if(Constants.TPTP_DEBUG) System.out.println("Failed to validate process : reported by "+srciid+" Err Code: "+errCode+" Message: "+errInfo);
 			}
	
	 	 }
	 	 catch(InactiveAgentException e){throw e;}
	 	}
		if (!TPTP_AC)
		{
			throw new NotSupportedException(Constants.ERR_NOT_SUPPORTED);
		}
		return _validApp;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#listAgents()
	 */
	public Enumeration listAgents() 
	{
		return _agents.elements();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getAgent(java.lang.String)
	 */
	public IAgent getAgent(String name) 
	{
	  synchronized(_agents) 
	  {
	  	Enumeration agents=listAgents();
		 while(agents.hasMoreElements()) 
		 {
		    IAgent agent=(IAgent)agents.nextElement();
		    if(agent.getName().equals(name)) 
		    {
		    	return agent;
		    }
		 }
	  }//synchronize
	  return null;
	 }
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getAgentsByType(java.lang.String)
	 */
	public Enumeration getAgentsByType(String type) 
	{
	  Vector ret = new Vector();
//	  synchronized(_agents) 
//	  {
//	  	Enumeration agents=listAgents();
//		 while(agents.hasMoreElements()) 
//		 {
//		    IAgent agent=(IAgent)agents.nextElement();
//		    if(agent.getType().equals(type)) 
//		    {
//		    	ret.addElement(agent);
//		    }
//		 }
//	  }//synchronize
	  return ret.elements();
	 }

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#addEventListener(java.lang.String, org.eclipse.tptp.platform.execution.core.ICommandHandler)
	 */
/*	public void addEventListener(String interfaceID, ICommandHandler listener) 
	{
		ProcessEventListener pl = new ProcessEventListener(interfaceID, listener);
		synchronized(_listeners)
		{
			if(!_listeners.contains(pl))
			{
				_listeners.add(pl);
			}
		}
	}
	public void removeEventListener(String interfaceID, ICommandHandler listener)
	{
	    
	
	}*/
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getNode()
	 */
	public INode getNode() throws InactiveProcessException {
		return this._node;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#setName(java.lang.String)
	 */
	public void setName(String name) 
	{
		_processInfo.setProcessName(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#setDestID(int)
	 */
	public void setDestID(int destID) 
	{
		this._destID = destID;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getDestID
	 */
	public int getDestID() throws InactiveAgentException
	{
		if (this._destID != -1) return this._destID;
		else
		{
			try
			{
				IAgent pc = this._ac.getAgent(pcAgentName, TPTPAgentAccess.TPTP_OBSERVER_ACCESS);
				if(pc == null){throw new InactiveAgentException();}
				this._destID = ((AgentImpl)pc).getAgentInstanceId();
			}
			catch(Exception e){new InactiveAgentException(Constants.TPTP_PLATFORM_EXEC_MSG29);}
		  return this._destID;
		}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getName()
	 */
	public String getName() 
	{
		return _processInfo.getProcessName();
	}
	
	//223385
	/**
	*
	* return UUID of process or null.
	*/	
	private String queryProcessUUID(long pid, int destID) throws NotConnectedException {
		AgentController ac;
		try{
			ac = (AgentController) _ac;
		}catch(ClassCastException e){
			return null;
		}
		
		if(! ac.isConnected()) throw new NotConnectedException(Constants.TPTP_PLATFORM_EXEC_MSG17);

		final Object _launcherLock 	= new Object();
		
		final GenericCommandHandler genCmdHandler = new GenericCommandHandler();
		if(ac.isTPTP_AC()){
			try{
				synchronized(_launcherLock){
		 		   try{ 	
			 		   	GetProcessUUIDCommand command= new GetProcessUUIDCommand(pid+"");
			 		   	
			 		   	ac.sendCommand(command.buildCommand(), destID, new ICommandHandler()
			 		   	{
			 		   		public void incomingCommand(INode node, ICommandElement command)
			 		   		{
			 		   			genCmdHandler.setCommandElement(command);
			 		   		}
			 		   	});
			 		   	try{
			 		   		_launcherLock.notifyAll();
			 		   	}catch(Exception e){
			   				e.printStackTrace();}
					   	}
	 			   	catch(Exception e){e.printStackTrace();}
				} //synchronized
			 }catch(Exception e){
				 e.printStackTrace();}
			 }
		
			synchronized (_launcherLock) {
				int processLauchTimeOut = 0;
		 	    while(genCmdHandler.getCommandElement() == null )
		 	    {
		 	        try
		 	        {		 	        	
		 	        	_launcherLock.wait(Constants.TIMEOUT_PERIOD);
		 	        	if (processLauchTimeOut == Constants.PROCESS_LAUNCH_TIMEOUT_TRY_COUNT)
		 	        	{
		 	        		throw new TimeoutException(Constants.TPTP_PLATFORM_EXEC_MSG33);		
		 	        	}
		 	        	processLauchTimeOut++;
		 	        	if (Constants.TPTP_DEBUG) System.out.println("The Process Launch Timeout count" + processLauchTimeOut);
		 	        }
		 	        catch(Exception e)
		 	        {
		 	        	_launcherLock.notifyAll();
		 	        	e.printStackTrace();
		 	        	break;
		 	        }
		 	    }
		 	    _launcherLock.notifyAll();
		 	}

			
			if (genCmdHandler.getCommandElement() == null) {
				return null;
			} 
			String commandStr = ((CommandFragment)genCmdHandler.getCommandElement()).getCommandData();
			
			TPTPXMLParse ParseObj = new TPTPXMLParse();
			ParseObj.setParser(commandStr);
				
			Hashtable ch = ParseObj.getHashTable();
			if(ch.containsKey("processUUID") ){
				return (String) ch.get("processUUID");
			}else{
				return null;
			}			
	}
	

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getUUID()
	 */
	public String getUUID() 
	{
		//223385
		try{
			if(this._UUID == null){
		
				this._UUID = queryProcessUUID(getProcessId(), getDestID());				
			}
		}catch(InactiveAgentException e){	e.printStackTrace();	
		}catch(InactiveProcessException e){	e.printStackTrace();	
		}catch(NotConnectedException e){	e.printStackTrace();	
		}
		
		//return this._UUID;
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#setExecutable(java.lang.String)
	 */
	public void setExecutable(String exe) throws ProcessActiveException 
	{
		_processInfo.setExecutable(exe);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getExecutable()
	 */
	public String getExecutable() {
		return _processInfo.getExecutable();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getProcessId()
	 */
	public long getProcessId() throws InactiveProcessException 
	{
		return this._processId;
	}
	
	public void setProcessId(long processId)
	{
		_processId = processId;
		_isActive = true;

		try 
		{
			IProcess proc = ((AgentController)_ac).getProcess(processId);
		} 
		catch (Exception e) 
		{
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#isActive()
	 */
	public boolean isActive() 
	{
		return this._isActive;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getConsole()
	 */
	public IConsole getConsole() 
	{
		if (this._console == null){this._console = new ConsoleImpl();}
		return this._console;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#addEnvironmentVariable(java.lang.String, java.lang.String)
	 */
	public void setEnvironmentVariable(String name, String value)
			throws ProcessActiveException 
	{
		if(!(_isActive))
		{ 
			Variable tempvar = new Variable(name, value,""); 
			_variables.addElement(tempvar);
			_processInfo.addEnvironmentVariable(name, value);
		}
		else throw new ProcessActiveException(Constants.TPTP_PLATFORM_EXEC_MSG30);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getEnvironmentVariable(java.lang.String)
	 */
	public Variable getEnvironmentVariable(String name) 
	{
		Variable TempVar = null;
		String EnvVal = _processInfo.getEnvironmentVariable(name);
		if (EnvVal != null)
		{
			TempVar = new Variable();
			TempVar.setName(name);
			TempVar.setValue(EnvVal);
		}
	 return TempVar;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#removeEnvironmentVariable(java.lang.String)
	 */
	public void removeEnvironmentVariable(String name)
			throws ProcessActiveException 
	{
		if(_isActive) 
		{	
			_processInfo.removeEnvironmentVariable(name);
		}
		else 
			throw new ProcessActiveException(Constants.TPTP_PLATFORM_EXEC_MSG31);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getEnvironment()
	 */
	public Enumeration getEnvironment() 
	{
		return _variables.elements();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#setParameters(java.lang.String)
	 */
	public void setParameter(String parameters) throws ProcessActiveException 
	{
		_processInfo.setParameters(parameters);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getParameters()
	 */
	public String getParameter() 
	{
		return _processInfo.getParameters();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#setLocation(java.lang.String)
	 */
	public void setLocation(String location) throws ProcessActiveException 
	{
		_processInfo.setWorkingDirectory(location);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getLocation(java.lang.String)
	 */
	public String getLocation() 
	{
		return _processInfo.getWorkingDirectory();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getProcessInfo()
	 */
	public ProcessInfo getProcessInfo() 
	{
		return this._processInfo;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#setProcessInfo(org.eclipse.tptp.platform.execution.core.ProcessInfo)
	 */
	public void setProcessInfo(ProcessInfo pInfo) 
	{
		this._processInfo = pInfo;
		
	}
	public void prependParameter(String parameter) throws ProcessActiveException {
		if (parameter == null) return;
		
		String params = getParameter();
		if (params != null) parameter += " " + params; 
		setParameter(parameter);
	}
	
	public void appendParameter(String parameter) throws ProcessActiveException {
		if (parameter == null) return;
		
		String params = getParameter();
		if (params != null) parameter = params + " " + parameter; 
		setParameter(parameter);
	}
	
	public void appendEnvironmentVariable(String name, String value) throws ProcessActiveException
	{
		Variable var = new Variable(name, value,"append");
		synchronized(_variables)
		{
			//add at the end
			_variables.add(var);
			_processInfo.addEnvironmentVariable(name, value);
		}
	}
	public void prependEnvironmentVariable(String name, String value) throws ProcessActiveException
	{
		Variable var = new Variable(name, value,"prepend");
		synchronized(_variables)
		{
			//add at the beginning
			_variables.add(0,var);
			_processInfo.addEnvironmentVariable(name, value);
		}
	}
	public void setSource(int clientSrcID)
	{
		this._srcID = clientSrcID;
	}
	
	public void launchAC() throws ProcessActiveException, NotConnectedException, NoSuchApplicationException, InactiveAgentException, TimeoutException 
	{
		 try
		 {
		 	if(this.getConsole() == null)
		 	{ 
		 		this._console = new ConsoleImpl();
		 		this._console.setAC(this._ac);
		 		this._console.setTPTPAC(true);
		 	}
		 	if(this._console.getAC() == null)
		 	{
		 		this._console.setAC(this._ac);
		 		this._console.setTPTPAC(true);	
		 	}
		 	
			//Get the PC destID
		 	this._destID = getDestID();
		 	if(this._destID == -1) { throw new InactiveAgentException(Constants.TPTP_PLATFORM_EXEC_MSG32); }
	 		LaunchProcessCommand command = new LaunchProcessCommand();
	 		command.setProtocolVersion(((AgentController)_ac).getProtocolVersion());
	 		command.setExecutable(_processInfo.getExecutable()); 
	 		command.setLocation(_processInfo.getWorkingDirectory()); 
			command.setParameter(_processInfo.getParameters()); 
			command.setEnvironment(_variables);
			command.setDestination(this._destID);
 			command.setSource(((ConnectionImpl)(((AgentController)_ac).getConnection())).getConnectionId());
 			command.setContext(((AgentController)_ac).getNextContextId());
 			
 			if (_console != null && _console.getDataProcessor() != null) {
 				_consoleDataConnectID = ((AgentController)this._ac).getConsoleDataConnection(3);
 				command.setConsoleConnectID(_consoleDataConnectID); 
 				this._console.setDataConnectionID(_consoleDataConnectID);
				((AgentController)this._ac).addDataListener(_consoleDataConnectID, _dataProcessor = _console.getDataProcessor()); /* Bug 165948 */
 			}
 			
 			ProcessCommandHandler processCmdHandler = new ProcessCommandHandler (this);
		   	((AgentController)_ac).sendCommand(command.buildCommand(), this._destID, processCmdHandler);
		   	
	   		if (!processCmdHandler.waitResponce(Constants.processStarted_Cmd)) {
        		throw new TimeoutException(Constants.TPTP_PLATFORM_EXEC_MSG33);		
	   		}

			Enumeration listenerList=_listeners.elements();
			while(listenerList.hasMoreElements()) {
				((IProcessListener)listenerList.nextElement()).processLaunched(this);
			}
		 } catch (IOException e) {
			 e.printStackTrace();
		 }
	}
	//To Do 
	public void handleCommand(ICommandElement command) 
	{
		String commandStr = new String(((CommandFragment)command).getCommandData());
		TPTPXMLParse ParseObj = new TPTPXMLParse();
		ParseObj.setParser(commandStr);
		Hashtable CommandHash = ParseObj.getHashTable();
		_processId	= 0;
					
		if(CommandHash.containsKey("processID"))
		{
			_processId = Long.parseLong((String)ParseObj.getHashTable().get("processID"));
			_isActive	= true;
			//Now that you have the PID create a ConsoleData Processor
			ConsoleDataProcessor consoleMap = ((AgentController)this._ac).getConsoleMapper();
			((AgentController)this._ac).addDataListener(this._consoleDataConnectID, _dataProcessor = (IDataProcessor)consoleMap);
			this._console.setProcessID(_processId);
			consoleMap.addDataProcessor(_processId,_console.getDataProcessor());
		}			
		if(ParseObj.getHashTable().containsKey(Constants.TPTP_CBE_ERROR))
		{
			//Get the Msg and set Error true, throw ErrOr Message
		}
		if(ParseObj.getHashTable().containsKey(Constants.processStopped_Cmd))
		{ 	
			String processTerminated = (String)ParseObj.getHashTable().get(Constants.processStopped_Cmd);
			_isActive	= false;
			this._processListener.processExited(this);
		}
		if(ParseObj.getHashTable().containsKey(Constants.processExited_Cmd))
		{
			String processTerminated = (String)ParseObj.getHashTable().get(Constants.processExited_Cmd);
			_isActive	= false;
			this._processListener.processExited(this);
		}
		
		if(ParseObj.getHashTable().containsKey(Constants.agentProcessExited_Cmd))
		{
			_isActive	= false;
			synchronized(_listeners) {
				Enumeration elements = _listeners.elements();
				while(elements.hasMoreElements()) {
					IProcessListener listener = (IProcessListener) elements.nextElement();
					listener.processExited(this);
				}
			}	
		}
	}
	
	public void connectionClosed(IConnection connection) {
		synchronized(_listeners) {
			_isActive = false;
			Enumeration elements = _listeners.elements();
			while(elements.hasMoreElements()) {
				//DO NOTHING FOR NOW;
			}
		}	
	}
	
    /**
     * Add a Process Listener
     * @return        
     */
    public void addProcessListener(IProcessListener listener)
	{
    	synchronized(_listeners)
		{
			if(!_listeners.contains(listener))
			{
				_listeners.add(listener);
			}
		}
	}
    
    /**
     * Add a Process Listener
     * @return        
     */
    public void removeProcessListener(IProcessListener listener)
	{
    	synchronized(_listeners)
		{
			if(!_listeners.contains(listener))
			{
				_listeners.remove(listener);
			}
		}
	}    
	
    public Vector getProcessListener()
    {
    	return _listeners;
    }
	
	class ProcessEventListener implements IProcessListener {
		ProcessEventListener(int contextID, String eventInterfaceID, final IProcess processObj)
		{
			((ConnectionImpl)(((AgentController)_ac).getConnection())).getContextMapper().addContext(contextID, new ICommandHandler(){
			    
			    public void incomingCommand(INode node, ICommandElement command)
	   			{
		        	String commandStr = ((CommandFragment)command).getCommandData();
	 				TPTPXMLParse ParseObj = new TPTPXMLParse();
	 				ParseObj.setParser(commandStr);
	 				Hashtable commandHash = ParseObj.getHashTable();
	 				//TODO:Clean up resources, shut off Console, set ProcessActive false
	 				//TODO: Do nothing if the Proc/Agent are bound - the AC will send an event
	 				if(Constants.TPTP_DEBUG) System.out.println("Process Event Message " + commandStr);
	 				if(commandHash.containsKey(Constants.processExited_Cmd)) { 	
	 					if(Constants.TPTP_DEBUG) System.out.println("Received process exited event");
	 					_isActive	= false;
	 					processExited(processObj);
	 				}
	   			}
			});
		}
		
		public void processLaunched(IProcess process) 
		{	
			if(Constants.TPTP_DEBUG) System.out.println("Process Launched");
			Enumeration listenerList = null;
			synchronized(_listeners) 
			{
				listenerList=_listeners.elements();
				while(listenerList.hasMoreElements()) 
				{
					((IProcessListener)listenerList.nextElement()).processLaunched(process);
				}
			}
		}
		
		/**
		  * @see ProcessListener#processExited
		  */
		public void processExited(IProcess process) 
		{
			if(Constants.TPTP_DEBUG) System.out.println("Process Exited");
			Enumeration listenerList = null;
			synchronized(_listeners) 
			{
				listenerList=_listeners.elements();
				while(listenerList.hasMoreElements()) 
				{
					((IProcessListener)listenerList.nextElement()).processExited(process);
				}
			}
		}		
	}	
	public void run()
	{
		while(_isActive)
		{
			final GenericCommandHandler genCmdHandler = new GenericCommandHandler();
			if(TPTP_AC)
			{
				try
				{
					if (this._destID == -1)
					{
						this._destID = this.getDestID();
						if(this._destID == -1){throw new InactiveAgentException(Constants.TPTP_PLATFORM_EXEC_MSG26);}
					}
					try 
						{
							org.eclipse.tptp.platform.execution.client.core.internal.commands.KillProcessCommand command= new org.eclipse.tptp.platform.execution.client.core.internal.commands.KillProcessCommand(this._processId);
							((AgentController)_ac).sendCommand(command.buildCommand(), this._destID, new ICommandHandler(){
								public void incomingCommand(INode node, ICommandElement command)
								{
									genCmdHandler.setCommandElement(command);
								}
							});
						}
						catch(Exception e){e.printStackTrace();}
						int trycount = 0;
			 	    while(genCmdHandler.getCommandElement() == null || trycount < 16)
			 	    {
			 	        trycount++;
			 	        Thread.sleep(500);
			 	    }
			 
		 			if (genCmdHandler.getCommandElement() == null) {_isActive = false;}
		 			String commandStr = ((CommandFragment)genCmdHandler.getCommandElement()).getCommandData();
		 			TPTPXMLParse ParseObj = new TPTPXMLParse();
		 			ParseObj.setParser(commandStr);
		 			Hashtable commandHash = ParseObj.getHashTable();
		 			
		 			if(commandHash.containsKey("TPTP_Error")) {
		 				throw new InactiveProcessException(Constants.TPTP_PLATFORM_EXEC_MSG26); 
		 			}
		 			if(commandHash.containsKey(Constants.processStopped_Cmd)) { 	
		 				AgentController ac = (AgentController) this._ac;
		 				ac.removeProcess(this._processId);
		 				String processTerminated = (String)commandHash.get(Constants.processStopped_Cmd);
		 				if(processTerminated.equals(Constants.processStopped_Cmd)){ _isActive	= false; }
		 			}	
				 }
				catch(Exception e){
					_isActive = false;
				}
			}
		}
	}

	public void setExitCode (int exitCode) {	/* Bug 167208 */
		this.exitCode = exitCode;
	}
	
	public int getExitCode () {	/* Bug 167208 */
		return exitCode;
	}

	class Request {	/* Bug 166831, 166834 */
		public final static int WAIT = 0;
		public final static int PROCESSED = 1;
		public final static int ERROR = 2;
		 
		public String command;
		public int status;
		public String errCode;
		public String errInfo;
		
		public Request (String command) {
			this.command = command;
			status = WAIT;
		}
	}
	
	class ProcessCommandHandler implements ICommandHandler {	/* Bug 166831, 166834 */
		private ProcessImpl process;
		private Map waitingRequests;

		public ProcessCommandHandler(ProcessImpl process) {
			this.process = process;
			waitingRequests = new HashMap ();
		}

		public synchronized void incomingCommand(INode node, ICommandElement commandElement) {
			TPTPXMLParse parseObj = new TPTPXMLParse();
			String commandStr = ((CommandFragment) commandElement).getCommandData();
			parseObj.setParser(commandStr);
			Hashtable commandHash = parseObj.getHashTable();
				
			boolean error = false;
			String errCode = null;
			String errInfo = null;
			String command = null;
			
			if(commandHash.containsKey("TPTP_Error")) {
				error = true;
 				errCode= (String) commandHash.get("ErrCode");
 				errInfo= (String) commandHash.get("ErrInfo");
			} else if (commandHash.containsKey (Constants.processStarted_Cmd)) {
				command = Constants.processStarted_Cmd;
				processStarted(commandHash);
			} else if(commandHash.containsKey (Constants.processExited_Cmd)) {
				command = Constants.processExited_Cmd;
				processExited(commandHash);
			} else if(commandHash.containsKey (Constants.processStopped_Cmd)) {
				command = Constants.processStopped_Cmd;
				processExited(commandHash);
			}
		
			if (error) {
				if (waitingRequests.size() > 0) {
					Iterator itr = waitingRequests.values().iterator();
					while (itr.hasNext()) {
						Collection requests = (Collection) itr.next();
						if (requests.size() > 0) {
							Iterator it = requests.iterator();
							while (it.hasNext()) {
								Request req = (Request) it.next();
								req.status = Request.ERROR;
								req.errCode = errCode;
								req.errInfo = errInfo;
							}
						}
					}
				
					notifyAll();
				}
			} else if (command != null) {
				Collection requests = (Collection) waitingRequests.get(command);
				if (requests != null && requests.size() > 0) {
					Iterator it = requests.iterator();
					while (it.hasNext()) {
						Request req = (Request) it.next();
						req.status = Request.PROCESSED;
					}
				
					requests.clear();
					notifyAll();
				}
			}			
		}

		private void processStarted(Hashtable commandHash) {	
			_isActive	= true;

			String s = (String) commandHash.get("processID");
			if(s != null) {
				long processId = Long.parseLong(s);
				process.setProcessId(processId);
				
				//223385
				process._UUID = (String) commandHash.get("processUUID");
				
				((AgentController)(process._ac)).attachProcess(process);
			}
		}
	
		private void processExited(Hashtable commandHash) {
			_isActive	= false;

			String s = (String) commandHash.get("exitCode");
			if(s != null) {
				long exitCode = Long.parseLong(s);
				process.setExitCode((int)exitCode);
			}

			Enumeration listenerList = _listeners.elements();
			while(listenerList.hasMoreElements()) {
				((IProcessListener)listenerList.nextElement()).processExited(process);
			}

			// cleanup console internal resources
			if (_dataProcessor != null && _consoleDataConnectID != -1)
				((AgentController)_ac).removeDataListener(_consoleDataConnectID, _dataProcessor);

			try {
				((AgentController)(process._ac)).removeProcess(process.getProcessId());
			} catch (Exception ignored) {
			}
		}		
	
		public synchronized boolean waitResponce (String waitCommand) throws NoSuchApplicationException {
			String cmd;
			if (Constants.processStarted_Cmd.equals(waitCommand)) {
				if (process.isActive()) return true;
				cmd = Constants.processStarted_Cmd;
			} else if (Constants.processExited_Cmd.equals(waitCommand)) {
				cmd =Constants.processExited_Cmd;
			} else if (Constants.processStopped_Cmd.equals(waitCommand)) {
				cmd = Constants.processStopped_Cmd;
			} else
				cmd = null;
		
			if (cmd == null) return false;

			Request req = new Request (cmd);
			addRequest (req);
					
			boolean result = false;
			long dtmax = System.currentTimeMillis() + Constants.TIMEOUT_PERIOD*Constants.PROCESS_LAUNCH_TIMEOUT_TRY_COUNT;
		
			while (true) {
				long interval = dtmax - System.currentTimeMillis();
				if (interval <= 0) break;
			
				try {
					wait (interval);
				} catch (Exception e) {
				}

				if (req.status == Request.ERROR) {
					throw new NoSuchApplicationException(Constants.TPTP_PLATFORM_EXEC_MSG34 + req.errCode + " and " + req.errInfo);
				}
				
				if (req.status == Request.PROCESSED) {
					result = true;
					break;
				}				 
			}

			return result;
		}		
	
		private void addRequest (Request req) {
			Set requests = (Set) waitingRequests.get(req.command);
			if (requests == null) {
				requests = new HashSet ();
				waitingRequests.put(req.command, requests);
			}
			requests.add (req);
		} 
	}
}
