/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/ 

package org.eclipse.tptp.platform.execution.client.core.internal;

import java.util.*;

/**
 * This class provides the capability to encapsulate Process related information
 * that is required to launch a target process.  
 *
 * @since tptp 4.0 (New interface)
 * 
 */
public class ProcessInfo
{
	/** 
	 * Process Name
	 */
	private String _processName;
	
	/**
	 * Executable Path 
	 */
	private String _executable;
	
	/**
	 * Environment Variable Collection
	 */
	private Hashtable _environment;
	
	/**
	 * Parameters or arguments list
	 */
	private String _parameters;
	
	/**
	 * Working Directory from where process will be launched
	 */
	private String _workingDir;

	public ProcessInfo()
	{
		_processName = new String();
		_executable  = new String();
		_environment = new Hashtable();
		_parameters	 = new String();
		_workingDir  = new String();
	}
	/**
	 *  Set the Process Name 
	 */
	public void setProcessName(String name)
	{
			_processName = name;
	}
	
	/** 
	 * get the Process Name 
	 */
	public String getProcessName()
	{
		return _processName;
	}
	
	/** 
	 * Get the Executable name/path 
	 */
	public String getExecutable()
	{
		return _executable;
	}
	
	/** 
	 * Set the Executable name/path 
	 */
	public void setExecutable(String executable)
	{
		_executable = executable;
	}
	
	/** 
	 * Add an environment variable to the process launch config 
	 */
	public void addEnvironmentVariable(String name, String value)
	{
		_environment.put(name, value);
	}
	
	/** 
	 * Return the Environment variable name and value 
	 */
	public String getEnvironmentVariable(String name)
	{
		if ((_environment.get(name)) == null)
			return null;
		else return (_environment.get(name)).toString();
	}
	
	/** 
	 * Remove the environment variable
	 */
	public void removeEnvironmentVariable(String name)
	{
		_environment.remove(name);
	}
	
	/** 
	 * Get the process launch environment 
	 */
	public Hashtable getEnvironment()
	{
		return _environment;
	}
	
	/** 
	 * Set the parameters/arguments 
	 */
	public void setParameters(String parameters)
	{
		_parameters = parameters;
	}
	
	/** 
	 * Get the parameters/arguments 
	 */
	public String getParameters()
	{
		return _parameters;
	}
	
	/** 
	 * Set the working directory for launching the process 
	 */
	public void setWorkingDirectory(String location)
	{
		_workingDir = location;
	}
	
	/** 
	 * get the working directory for launching the process 
	 */
	public String getWorkingDirectory()
	{
		return _workingDir;
	}
}