/*******************************************************************************
 * Copyright (c) 2006, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    
 * $Id$
 *
 *******************************************************************************/
package org.eclipse.tptp.platform.execution.client.core.internal;

import java.io.IOException;
import java.net.Socket;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;

import org.eclipse.tptp.platform.execution.client.core.INode;
import org.eclipse.tptp.platform.execution.exceptions.LoginFailedException;
import org.eclipse.tptp.platform.execution.exceptions.ReconnectRequestedException;
import org.eclipse.tptp.platform.execution.exceptions.SecureConnectionRequiredException;
import org.eclipse.tptp.platform.execution.exceptions.UntrustedAgentControllerException;

public class SecureConnectionImpl extends ConnectionImpl {
    private SSLSocket initSSL (Socket socket) throws IOException {
    	if (socket == null || !socket.isConnected()) return null;
    	
		TrustManager tms[] = null;
		try {
			X509TrustManagerImpl tm = new X509TrustManagerImpl();
			tms = new TrustManager[1];
			tms[0] = tm;
		} catch (Exception e) {}
		
		SSLContext sslCtx;
		try {
			sslCtx = SSLContext.getInstance("SSL");
			sslCtx.init(null, tms, null);
		}
		catch(Exception e) {
			sslCtx = null;
		}
		
		if (sslCtx == null) return null;
		
		String host = socket.getInetAddress().getHostAddress();
		int port = socket.getPort();
		
		SSLSocket sslSocket = (SSLSocket) sslCtx.getSocketFactory().createSocket(socket, host, port, true);
		sslSocket.setUseClientMode(true);

		sslSocket.startHandshake();

		if (sslSocket.getSession() == null) return null;
		
		return sslSocket;
    }
    
    public boolean connect(INode node, ConnectionImpl con) throws IOException, UntrustedAgentControllerException, 
    	ReconnectRequestedException, SecureConnectionRequiredException, LoginFailedException {

    	if (con == null) return false;
    	Socket socket = con.getSocket();
    	if (socket == null || !socket.isConnected()) return false;
    	
    	con.setSocket(null);	// to save socket from garbage collecting
    	
		setSoTimeout(socket.getSoTimeout());
		_node = node;
		_port = socket.getPort();
		inetAddress = socket.getInetAddress();
			
		SSLSocket sslSocket = initSSL(socket);
		if (sslSocket == null) return false;
		
		setSocket (sslSocket);

		init();		// to complete connection establishment
		
		return true;
    }
    
	public int createDataConnection(int direction) throws IOException, SecureConnectionRequiredException {
		Socket dataSock = connectSocket();
		if (dataSock == null) throw new IOException();

		int dataConnectionId = -1;
		boolean securityRequired = false;

		try {
			dataConnectionId = initDataConnection(dataSock, direction);
		} catch (SecureConnectionRequiredException e) {
			securityRequired = true;
		}
		
		if (!securityRequired) return dataConnectionId;
		
		SSLSocket sslDataSock = initSSL(dataSock);
		
		return initDataConnection(sslDataSock, direction);
	}
}