/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *
 * $Id: TPTPMessageDebug.java,v 1.2 2010/02/23 19:51:18 jwest Exp $ 
 *******************************************************************************/


package org.eclipse.tptp.platform.execution.client.core.internal;

import java.io.File;
import java.io.FileWriter;
import java.text.DateFormat;
import java.util.Date;

public class TPTPMessageDebug {
	
	public static final boolean TPTP_MSG_DEBUG = System.getenv("TPTP_MSG_DEBUG") != null && System.getenv("TPTP_MSG_DEBUG").equalsIgnoreCase("TRUE");
//	public static final boolean TPTP_MSG_DEBUG = true;
	
	public static final boolean TPTP_MSG_DEBUG_PRINT_MESSAGES =  System.getenv("TPTP_MSG_DEBUG_PRINT_MESSAGES") != null && System.getenv("TPTP_MSG_DEBUG_PRINT_MESSAGES").equalsIgnoreCase("TRUE");

	public static final boolean TPTP_MSG_DEBUG_PRINT_DATA_IN =  System.getenv("TPTP_MSG_DEBUG_PRINT_DATA_IN") != null && System.getenv("TPTP_MSG_DEBUG_PRINT_DATA_IN").equalsIgnoreCase("TRUE");
	public static final boolean TPTP_MSG_DEBUG_PRINT_DATA_OUT =  System.getenv("TPTP_MSG_DEBUG_PRINT_DATA_OUT") != null && System.getenv("TPTP_MSG_DEBUG_PRINT_DATA_OUT").equalsIgnoreCase("TRUE");
	
	public static final boolean TPTP_MSG_DEBUG_PRINT_CONSOLE_OUT =  System.getenv("TPTP_MSG_DEBUG_PRINT_CONSOLE_OUT") != null && System.getenv("TPTP_MSG_DEBUG_PRINT_CONSOLE_OUT").equalsIgnoreCase("TRUE");
	public static final boolean TPTP_MSG_DEBUG_PRINT_CONSOLE_IN =  System.getenv("TPTP_MSG_DEBUG_PRINT_CONSOLE_IN") != null && System.getenv("TPTP_MSG_DEBUG_PRINT_CONSOLE_IN").equalsIgnoreCase("TRUE");

//	public static final boolean TPTP_MSG_DEBUG_PRINT_MESSAGES =  true;
//	public static final boolean TPTP_MSG_DEBUG_PRINT_DATA_IN =  false;
//	public static final boolean TPTP_MSG_DEBUG_PRINT_DATA_OUT =  false;
//	
//	public static final boolean TPTP_MSG_DEBUG_PRINT_CONSOLE_IN =  false;
//	public static final boolean TPTP_MSG_DEBUG_PRINT_CONSOLE_OUT =  false;
	
	private static boolean _writeToConsole = System.getenv("TPTP_MSG_DEBUG_OUTPUT") != null && System.getenv("TPTP_MSG_DEBUG_OUTPUT").equalsIgnoreCase("CONSOLE");
	private static boolean _writeToFile = System.getenv("TPTP_MSG_DEBUG_OUTPUT") != null && System.getenv("TPTP_MSG_DEBUG_OUTPUT").equalsIgnoreCase("FILE");
	
	private static Object writeLock = new Object();
	
	private static String getTimestamp() {
		
		String str = DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.LONG).format(new Date());
		
		// Lazy time zone removal for East
		str = str.replaceAll(" EST", "");
		str = str.replaceAll(" EDT", "");
		return "["+str+"]  ";
	}
	
	
	public static void writeDebugMessage(String message) {
		writeDebugMessage(message, true);
	}
	
	public static void writeDebugMessage(String message, boolean endOfLineCRLF) {
		if(!TPTP_MSG_DEBUG) return;
		
		message = getTimestamp() + message;
		
		if(_writeToConsole) {
			
			synchronized(writeLock) {
				if(endOfLineCRLF) {
					System.out.println(message);
				} else {
					System.out.print(message);
				}
			}
			
		} else if(_writeToFile) {
			
			try {

				synchronized(writeLock) {
					File f = new File("c:\\tptp-msg-debug.log");
					FileWriter fw = new FileWriter(f, true);
					fw.write(message);
					if(endOfLineCRLF) {
						fw.write("\r\n");
					}
					fw.flush();
					fw.close();
				}
				
			} catch(Exception e) {
				e.printStackTrace();
			}
		}
						
	}
	
}
