/*******************************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Igor Alelekov, Intel - initial API and implementation
 *    
 * $Id: X509TrustManagerImpl.java,v 1.4 2007/09/06 11:45:40 jkubasta Exp $
 *
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.client.core.internal;

import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerImpl implements X509TrustManager {
	private X509TrustManager defaultX509tm; 
	
	X509TrustManagerImpl () throws Exception {
		TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
		tmf.init((KeyStore) null);
		
		TrustManager tms[] = tmf.getTrustManagers();
		for (int i=0; i<tms.length; i++) {
			if (tms[i] instanceof X509TrustManager) {
				defaultX509tm = (X509TrustManager) tms[i];
				break;
			}
		}
	}
	
	public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
		if (defaultX509tm == null) throw new CertificateException ("Trust manager not found");
		
		defaultX509tm.checkClientTrusted(certs, authType);
	}

	public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
		if (defaultX509tm != null)
			try {
				defaultX509tm.checkServerTrusted(certs, authType);
				return;
			} catch (Exception e) {}
			
// TODO: ask user if certificate is trusted, save it
	}

	public X509Certificate[] getAcceptedIssuers() {
		if (defaultX509tm != null) return defaultX509tm.getAcceptedIssuers();
		return null;
	}
}
