/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - Initial API and Implementation (TPTP 4.0)
 * 	  
 * $Id$
 *******************************************************************************/
/*
 * Created on May 2, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.tptp.platform.execution.client.core.internal.commands;

/**
 * @author gnagaraj
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

import java.util.Enumeration;

import org.eclipse.tptp.platform.execution.client.core.internal.ConnectionImpl;
import org.eclipse.tptp.platform.execution.client.core.internal.ControlMessage;
import org.eclipse.tptp.platform.execution.util.*;
import org.eclipse.tptp.platform.execution.util.internal.CommandElement;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.TPTPMessageUtil;
import org.eclipse.tptp.platform.execution.util.internal.TPTPString;

/**
 * @author gnagaraj
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AttachToAgentCommand extends CommandElement {

		protected String 	_agentName		= null;
		protected int	 	_agentID		= -1;
		protected int		_agentToken		= -1;
		//Default is Observer
		protected int	_accessMode	= TPTPAgentAccess.TPTP_OBSERVER_ACCESS.getValue();
		protected String	_commandName	= null;
				
		public AttachToAgentCommand(String commandName, String agentName, int agentID, int agentToken,TPTPAgentAccess accessMode)
		{
			this._agentName = agentName;
			this._commandName = commandName;
			this._agentToken = agentToken;
			this._agentID 	 = agentID;
			this._accessMode = accessMode.getValue();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getSize()
		 */
		public int getSize() 
		{
			return 0;
		}
		public long getContext() 
		{
			return _context;
		}
		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setContextID(java.lang.String)
		 */
		public void setContext(long contextID) {
			_context = contextID;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getSrcID()
		 */
		public long getSource() {
			return _src;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setSrcID(java.lang.String)
		 */
		public void setSource(long srcID) {
			_src = srcID;
		}
		//No TAG for TPTP 4.0
		public long getTag() {
			return _tag;
		}


		public long getDestination() {
			return _dest;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getInterfaceID()
		 */
		public String getInterfaceID() {
			return _iid;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setInterfaceID(java.lang.String)
		 */
		public void setInterfaceID(String interfaceID) {
			_iid = interfaceID;
		}
		
		public void setDestination(long dest) {
			_dest=dest;
		}
	 			
			
		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#buildCommand(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
		 */
		public String buildCommand() 
		{
			StringBuffer sbuf = new StringBuffer();
			sbuf.append("<");
			sbuf.append(this._commandName + " iid=\"");
			sbuf.append(Constants.AGNT_MGR_IID+"\"");
			sbuf.append(">");
			if((this._agentName) != null)
			{ sbuf.append("<agentName>"+this._agentName+"</agentName>"); }
			if((this._agentID) > 0)
			{ sbuf.append("<agentID>"+this._agentName+"</agentID>"); }
			if((this._agentToken) > 0)
			{ sbuf.append("<token>"+this._agentToken+"</token>"); }
			sbuf.append("<Flags>"+this._accessMode+"</Flags>");
			sbuf.append("</"+this._commandName +">");
			
			return sbuf.toString();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.IProcess#setExecutable(java.lang.String)
		 */
		/**
		* Read the command from the input buffer.
		* @return int
		* @param buffer byte[]
		* @param offset int
		*/
		public int readFromBuffer(byte[] buffer, int offset)
		{
			int current=offset;
			String retStr = null;
			current=TPTPMessageUtil.readTPTPStringFromBuffer(buffer, current, new TPTPString(retStr));
			//With the retStr value received parse the output for the specific elements
			return current;
		}

		/**
		* Write the XML Command to the input buffer.
		* @return int
		* @param buffer byte[]
		* @param offset int
		*/
		public int writeToBuffer(byte[] buffer, int offset)
		{
			int current=offset;
			current=TPTPMessageUtil.writeTPTPStringToBuffer(buffer, current, new TPTPString(this.buildCommand()));
			return current;
		}

}
