/*******************************************************************************
 * Copyright (c) 2007, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Igor Alelekov, Intel - initial API and implementation
 *    
 * $Id: AuthenticateCommand.java,v 1.5 2008/05/06 16:41:16 aalexeev Exp $
 *
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.client.core.internal.commands;

import org.eclipse.tptp.platform.execution.util.internal.CommandElement;
import org.eclipse.tptp.platform.execution.util.internal.TPTPMessageUtil;
import org.eclipse.tptp.platform.execution.util.internal.TPTPString;

public class AuthenticateCommand extends CommandElement {
	private TPTPString name;
	private TPTPString password;
	
	public AuthenticateCommand(String name, String password) {
		this.name = new TPTPString(name);
		this.password = new TPTPString(password);
	}
	
	public int getSize() {
		return name.getSize()
			+ password.getSize();
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		return 0;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		int current = TPTPMessageUtil.writeTPTPStringToBuffer(buffer, offset, name);
		return TPTPMessageUtil.writeTPTPStringToBuffer(buffer, current, password);
	}
}
