/*******************************************************************************
 * Copyright (c) 2008, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel - initial API and implementation
 *    
 * $Id: DataConnectionCommand.java,v 1.1 2008/04/07 06:12:34 ialelekov Exp $
 *
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.client.core.internal.commands;

import org.eclipse.tptp.platform.execution.util.internal.CommandElement;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.TPTPMessageUtil;

public class DataConnectionCommand extends CommandElement {
	private int direction;
	
	public DataConnectionCommand(int direction) {
		this.direction = direction;
	}
	
	public int getDirection() {
		return direction;
	}
	
	public int getSize() {
		return Constants.sizeofLong;
	}

	public int readFromBuffer(byte[] buffer, int offset) {
		return 0;
	}

	public int writeToBuffer(byte[] buffer, int offset) {
		return TPTPMessageUtil.writeTPTPLongToBuffer(buffer, offset, direction);
	}
}
