/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *
 * $Id: GetProcessUUIDCommand.java,v 1.1 2008/04/15 18:17:20 jkubasta Exp $ 
 *******************************************************************************/

package org.eclipse.tptp.platform.execution.client.core.internal.commands;

import java.util.Enumeration;

import org.eclipse.tptp.platform.execution.util.*;

import org.eclipse.tptp.platform.execution.exceptions.ProcessActiveException;
import org.eclipse.tptp.platform.execution.util.internal.CommandElement;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.TPTPMessageUtil;
import org.eclipse.tptp.platform.execution.util.internal.TPTPString;
import org.eclipse.tptp.platform.execution.util.internal.TPTPXMLParse;

/**
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class GetProcessUUIDCommand extends CommandElement {

	protected String	_processID 	= null;
	protected String	_commandData= null;
			
	public GetProcessUUIDCommand(String processID)
	{		
		this._commandData = new String();
		this._processID = processID;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getSize()
	 */
	public int getSize() 
	{
		return 0;
	}
	public long getContext() 
	{
		return _context;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setContextID(java.lang.String)
	 */
	public void setContext(long contextID) {
		_context = contextID;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getSrcID()
	 */
	public long getSource() {
		return _src;
	}
	public void setCommandData(String command) {
		this._commandData = new String(command);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.impl.commands.QueryRunningAgentsCommand#getCommandData()
	 */
	public String getCommandData() {
		return this._commandData;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setSrcID(java.lang.String)
	 */
	public void setSource(long srcID) {
		_src = srcID;
	}
	//No TAG for TPTP 4.0
	public long getTag() {
		return _tag;
	}


	public long getDestination() {
		return _dest;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getInterfaceID()
	 */
	public String getInterfaceID() {
		return _iid;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setInterfaceID(java.lang.String)
	 */
	public void setInterfaceID(String interfaceID) {
		_iid = interfaceID;
	}
	
	public void setDestination(long dest) {
		_dest=dest;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#buildCommand(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String buildCommand() 
	{
		StringBuffer sbuf = new StringBuffer();
		//<Cmd src= ctxt= dest= ><></Cmd>
		
		sbuf.append("<getProcessUUID iid=\""+Constants.PROC_CTLR_IID+"\">");
		sbuf.append("<processID>");
		sbuf.append(this._processID);
		sbuf.append("</processID></getProcessUUID>");
	
		this._commandData = sbuf.toString();
		return sbuf.toString();
	}

	
	/**
	* Read the command from the input buffer.
	* @return int
	* @param buffer byte[]
	* @param offset int
	*/
	public int readFromBuffer(byte[] buffer, int offset)
	{
		int current=offset;
		String retStr = null;
		current=TPTPMessageUtil.readTPTPStringFromBuffer(buffer, current, new TPTPString(retStr));
		//With the retStr value received parse the output for the specific elements
		TPTPXMLParse ParseObj = new TPTPXMLParse();
		ParseObj.setParser(retStr);
		Enumeration enumer = ParseObj.getHashTable().elements();
	
		return current;
	}
	/**
	* Write the XML Command to the input buffer.
	* @return int
	* @param buffer byte[]
	* @param offset int
	*/
	public int writeToBuffer(byte[] buffer, int offset)
	{
		int current=offset;
		current=TPTPMessageUtil.writeTPTPStringToBuffer(buffer, current, new TPTPString(buildCommand()));
		return current;
	}

}
