/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - Initial API and Implementation  
 * 	 
 * $Id$
 *******************************************************************************/
/*
 * Created on May 2, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.tptp.platform.execution.client.core.internal.commands;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

import org.eclipse.tptp.platform.execution.util.*;

import org.eclipse.tptp.platform.execution.exceptions.ProcessActiveException;
import org.eclipse.tptp.platform.execution.util.internal.CommandElement;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.TPTPMessageUtil;
import org.eclipse.tptp.platform.execution.util.internal.TPTPString;
import org.eclipse.tptp.platform.execution.util.internal.TPTPXMLParse;

/**
 * @author gnagaraj
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class LaunchProcessCommand extends CommandElement {

	//This ought to be in constants now --ProcControllerIID
	private static final String procCtlrIntIID 		= "org.eclipse.tptp.processController";
	private static final String procCtlrEvntIntIID 	= "org.eclipse.tptp.processController";
	
	private static final String startprocBeginTag 	= "<startProcess iid=\""+Constants.PROC_CTLR_IID+"\">";
	private static final String startprocCloseTag 	= "</startProcess>";
	private static final String responseTag			= "processStarted";
	//XML Element name for the ProcessController commands 
	private static final String appNameBeginTag 	= "<Application";
	private static final String appNameCloseTag 	= "</Application>";
	private static final String cmdLnArgsBeginTag 	= "<Parameter>";
	private static final String cmdLnArgsEndTag 	= "</Parameter>";
	private static final String wrkDirBeginTag 		= "location";
	private static final String envVarsBeginTag 	= "<Variable";
	
	private static final String keepRunningBeginTag = "<keepRunning>";
	private static final String keepRunningCloseTag = "</keepRunning>";
	private static final String noNoticesBeginTag = "<noNotices>";
	private static final String noNoticesCloseTag = "</noNotices>";
	private static final String consoleConnectIDBeginTag = "<consoleConnectID>";
	private static final String consoleConnectIDCloseTag = "</consoleConnectID>";

	private static final char SPACE = ' ';
	private static final char QUOTE = '\"';
	
	protected String 	_exe		= "";
	protected String 	_keepRunning= "0";
	protected String 	_noNotices	= "0";
	protected String 	_location	= ".";
	protected String 	_param		= null;
	protected int 		_consoleConnectID = -1;
	protected Collection	_environment = null;
	protected String	_processID 	= null;
	protected boolean	processStarted = false;
	protected String 	_commandData	= null;
	private int protoVersion = 0;
	
	public LaunchProcessCommand()
	{
		this._commandData = new String();
	}
	public LaunchProcessCommand(String exe, String location, String parameter, Collection environment)
	{
		this._exe = exe;
		this._location = location;
		this._environment = environment;
		this._commandData = new String();
		
		try {
			setParameter (parameter);
		} catch (ProcessActiveException e) {}
	}
	
	public Collection getEnvironment() {
		return _environment;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getParameters()
	 */
	public String getParameter() 
	{
		return this._param;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getSize()
	 */
	public int getSize() 
	{
		return 0;
	}
	public long getContext() 
	{
		return _context;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setContextID(java.lang.String)
	 */
	public void setContext(long contextID) {
		_context = contextID;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#setExecutable(java.lang.String)
	 */
	public void setParameter(String param) throws ProcessActiveException 
	{
		_param = addQuotes(param, "-data");
		_param = addQuotes(_param, "-launcher");
		_param = addQuotes(_param, "-configuration");
		_param = addQuotes(_param, "-dev");
	}

	private String addQuotes(String s, String key) {
		if (s == null || key == null) return s;

		int d = s.indexOf(key);
		if (d < 0) return s;
		
		int d1 = s.indexOf(SPACE, d);
		if (d1 < 0) return s;
		
		for (int i=d1+1; i<s.length(); i++) {
			char c = s.charAt(i);
			if (c == QUOTE) return s;	// already quoted
			
			if (c != SPACE) { d1 = i;  break; }
		}
		
		int d2 = s.indexOf(SPACE, d1);
		if (d2 < 0) return s;	
		
		if (s.charAt(d2+1) == QUOTE) return s;
		
		return s.substring(0, d+key.length()+1) + QUOTE + s.substring(d1, d2) + QUOTE + s.substring(d2); 
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#setEnvironment(java.util.Collection)
	 */
	public void setEnvironment(Collection environment) throws ProcessActiveException {
		_environment = environment;
	}

	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#setExecutable(java.lang.String)
	 */
	public void setExecutable(String exe) throws ProcessActiveException 
	{
		this._exe = exe;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getExecutable()
	 */
	public String getExecutable() {
		return this._exe;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getSrcID()
	 */
	public long getSource() {
		return _src;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setSrcID(java.lang.String)
	 */
	public void setSource(long srcID) {
		_src = srcID;
	}
	//No TAG for TPTP 4.0
	public long getTag() {
		return _tag;
	}


	public long getDestination() {
		return _dest;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getInterfaceID()
	 */
	public String getInterfaceID() {
		return _iid;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setInterfaceID(java.lang.String)
	 */
	public void setInterfaceID(String interfaceID) {
		_iid = interfaceID;
	}
	
	public void setDestination(long dest) {
		_dest=dest;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#setLocation(java.lang.String)
	 */
	public void setLocation(String location) throws ProcessActiveException 
	{
		this._location = location;
	} 
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getLocation(java.lang.String)
	 */
	public String getLocation() 
	{
		return this._location;
	}
	public void setKeepRunning(String KeepRunning) throws ProcessActiveException 
	{
		this._keepRunning = KeepRunning;
		
	} 
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getLocation(java.lang.String)
	 */
	public String getKeepRunning() 
	{
		return this._keepRunning;
	}
	public void setNoNotices(String noNotices) throws ProcessActiveException 
	{
		this._noNotices = noNotices;
		
	} 
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getLocation(java.lang.String)
	 */
	public String getNoNotices() 
	{
		return this._noNotices;
	}
	public void setConsoleConnectID(int consoleConnectID) 
	{
		this._consoleConnectID = consoleConnectID;
	} 
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getLocation(java.lang.String)
	 */
	public int getConsoleConnectID() 
	{
		return this._consoleConnectID;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#buildCommand(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String buildCommand() {
		_commandData = startProcCommand();
		return _commandData;
	}
	
	private String startProcCommand() {
		return (protoVersion <= 0) ? startProcCommandProtoVer_0() : startProcCommandProtoVer_1(); 
	}
	
	private String startProcCommandProtoVer_0() {
		StringBuffer sbuf = new StringBuffer(startprocBeginTag);
		sbuf.append("<launchInfo>");
		sbuf.append(appNameBeginTag);
		sbuf.append(" executable=\"").append(getExecutable()).append("\" ");
		sbuf.append(wrkDirBeginTag).append("=\"").append(getLocation()).append("\">");
				
		if (_param != null && _param.trim().length() > 0) 
			sbuf.append("<Parameter value=\"").append(getParameter()).append("\"/>");
			
		if (_environment != null && _environment.size() > 0) {
			Iterator it = _environment.iterator();
			
			while(it.hasNext()) {
				sbuf.append(envVarsBeginTag);
				Variable tempvar = (Variable) it.next();
				sbuf.append(" name=\"").append(tempvar.getName()).append("\" position=\"");
				sbuf.append(tempvar.getContext()).append("\" value=\"").append(tempvar.getValue()).append("\"/>");
			}
		}

		sbuf.append(appNameCloseTag);
		sbuf.append(keepRunningBeginTag);
		sbuf.append(getKeepRunning());				
		sbuf.append(keepRunningCloseTag);

		sbuf.append(noNoticesBeginTag);
		sbuf.append(getNoNotices());		
		sbuf.append(noNoticesCloseTag);
				
		sbuf.append("</launchInfo>");
		 		
		if(getConsoleConnectID() != -1) {
			sbuf.append(consoleConnectIDBeginTag);
			sbuf.append(getConsoleConnectID()); 
			sbuf.append(consoleConnectIDCloseTag);
		}
				
		sbuf.append(startprocCloseTag);
			
		return sbuf.toString();
	}
	
	private String startProcCommandProtoVer_1() {
		StringBuffer sbuf = new StringBuffer(startprocBeginTag);
		sbuf.append("<launchInfo>");
		sbuf.append(appNameBeginTag);
		sbuf.append(" executable=\"").append(getExecutable()).append("\" ");
		sbuf.append(wrkDirBeginTag).append("=\"").append(getLocation()).append("\">");
		
		if (_param != null && _param.trim().length() > 0) 
			sbuf.append(cmdLnArgsBeginTag).append(getParameter()).append(cmdLnArgsEndTag);		
		
		if (_environment != null && _environment.size() > 0) {
			Iterator it = _environment.iterator();
			
			while(it.hasNext()) {
				sbuf.append(envVarsBeginTag);
				Variable tempvar = (Variable) it.next();
				sbuf.append(" name=\"").append(tempvar.getName()).append("\" position=\"");
				sbuf.append(tempvar.getContext()).append("\" value=\"").append(tempvar.getValue()).append("\"/>");
			}
		}
			
		sbuf.append(appNameCloseTag);
		sbuf.append(keepRunningBeginTag);
		sbuf.append(getKeepRunning());				
		sbuf.append(keepRunningCloseTag);
		
		sbuf.append(noNoticesBeginTag);
		sbuf.append(this.getNoNotices());		
		sbuf.append(noNoticesCloseTag);
		
		sbuf.append("</launchInfo>");
		if(this.getConsoleConnectID() != -1) {
			sbuf.append(consoleConnectIDBeginTag);
			sbuf.append(this.getConsoleConnectID()); 
			sbuf.append(consoleConnectIDCloseTag);
		}
		
		sbuf.append(startprocCloseTag);
	
		return sbuf.toString();
	}

	public int getProtocolVersion() {
		return protoVersion;
	}
	
	public void setProtocolVersion(int protoVersion) {
		this.protoVersion = protoVersion;
	}
	
	/**
	* Read the command from the input buffer.
	* @return int
	* @param buffer byte[]
	* @param offset int
	*/
	public int readFromBuffer(byte[] buffer, int offset)
	{
		//The response from the startProcess looks like this
		/*
		<Cmd src="ProcessControllerConnectionID" dest="client" ctxt="ctxt_gen_by_client>
			<processStarted> 
				<processID>ProcessID</processID>
		    </processStarted>
		</Cmd>
		*/
		int current=offset;
		String retStr = null;
		current=TPTPMessageUtil.readTPTPStringFromBuffer(buffer, current, new TPTPString(retStr));
		//With the retStr value received parse the output for the specific elements
		TPTPXMLParse ParseObj = new TPTPXMLParse();
		ParseObj.setParser(retStr);
		Enumeration enumer = ParseObj.getHashTable().elements();
		
		while(enumer.hasMoreElements())
		{
			Object obj = enumer.nextElement();
			if(obj.toString().equals(responseTag))
			{ processStarted = true;}
			if(obj.toString().equals("processID"))
			{ processStarted = true;  
			  this._processID = (String)((ParseObj.getHashTable()).get(obj.toString())) ;	
			}
		}	
		return current;
	}
	/**
	* Write the XML Command to the input buffer.
	* @return int
	* @param buffer byte[]
	* @param offset int
	*/
	public int writeToBuffer(byte[] buffer, int offset)
	{
		int current=offset;
		current=TPTPMessageUtil.writeTPTPStringToBuffer(buffer, current, new TPTPString(this.buildCommand()));
		return current;
	}

}