/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Guru Nagarajan, Intel - Initial API and implementation
 *
 * $Id$ 
 *******************************************************************************/

package org.eclipse.tptp.platform.execution.client.core.internal.commands;

/**
 * @author gnagaraj
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

import org.eclipse.tptp.platform.execution.util.*;
import org.eclipse.tptp.platform.execution.util.internal.CommandElement;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.TPTPMessageUtil;
import org.eclipse.tptp.platform.execution.util.internal.TPTPString;

/**
 * @author gnagaraj
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class QueryAvailableAgntCommand extends CommandElement {

		protected String	_commandData= null;
		protected String[] _agentInterface = null;
		public QueryAvailableAgntCommand()
		{	this._commandData = new String();}

		
		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getSize()
		 */
		public int getSize() 
		{
			return 0;
		}
		public long getContext() 
		{
			return _context;
		}
		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setContextID(java.lang.String)
		 */
		public void setContext(long contextID) {
			_context = contextID;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getSrcID()
		 */
		public long getSource() {
			return _src;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setSrcID(java.lang.String)
		 */
		public void setSource(long srcID) {
			_src = srcID;
		}
		//No TAG for TPTP 4.0
		public long getTag() {
			return _tag;
		}
		public String getCommandData()
		{		
			return this._commandData;
		}
		public void setCommandData(String commanddata)
		{		
			this._commandData = commanddata;
		}

		public long getDestination() {
			return _dest;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getInterfaceID()
		 */
		public String getInterfaceID() {
			return _iid;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setInterfaceID(java.lang.String)
		 */
		public void setInterfaceID(String interfaceID) {
			_iid = interfaceID;
		}
		
		public void setDestination(long dest) {
			_dest=dest;
		}
		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getInterfaceID()
		 */
		public String[] getAgentInterfaceID() {
			return this._agentInterface;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setInterfaceID(java.lang.String)
		 */
		public void setAgentInterfaceID(int numCount, String[] agentType) 
		{
			if (numCount == 0) return; 
			this._agentInterface = new String[numCount];
			
			for(int i = 0; i < agentType.length; i++)
			{
				this._agentInterface[i] = agentType[i];	
			}
		}
		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#buildCommand(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
		 */
		public String buildCommand() 
		{
			StringBuffer sbuf = new StringBuffer();
			sbuf.append("<");
			sbuf.append(Constants.queryAvailableAgents_Cmd + " iid=\"");
			sbuf.append(Constants.AGNT_MGR_IID+"\"");
			sbuf.append(">");
			if(this._agentInterface != null)
			{
			  for(int i = 0; i < this._agentInterface.length; i++)
			  {
				sbuf.append("<interface>"+this._agentInterface[i]+"</interface>");
			  }
			}
			sbuf.append("</"+Constants.queryAvailableAgents_Cmd+">");
			return sbuf.toString();
		}

		/* (non-Javadoc)
		 * @see org.eclipse.tptp.platform.execution.core.IProcess#setExecutable(java.lang.String)
		 */
				/**
		* Read the command from the input buffer.
		* @return int
		* @param buffer byte[]
		* @param offset int
		*/
		public int readFromBuffer(byte[] buffer, int offset)
		{
			int current=offset;
			_context=TPTPMessageUtil.readTPTPLongFromBuffer(buffer, current);
			current+=Constants.sizeofLong;
			return current;
		}

		/**
		* Write the XML Command to the input buffer.
		* @return int
		* @param buffer byte[]
		* @param offset int
		*/
		public int writeToBuffer(byte[] buffer, int offset)
		{
			int current=offset;
			current=TPTPMessageUtil.writeTPTPStringToBuffer(buffer, current, new TPTPString(this.buildCommand()));
			return current;
		}

}

