/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan, Intel - Initial API and Implementation 
 * $Id$
 *******************************************************************************//*
 * Created on May 2, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.tptp.platform.execution.client.core.internal.commands;

import org.eclipse.tptp.platform.execution.util.*;
import org.eclipse.tptp.platform.execution.exceptions.ProcessActiveException;
import org.eclipse.tptp.platform.execution.util.internal.CommandElement;
import org.eclipse.tptp.platform.execution.util.internal.Constants;
import org.eclipse.tptp.platform.execution.util.internal.TPTPMessageUtil;
import org.eclipse.tptp.platform.execution.util.internal.TPTPString;

/**
 * @author gnagaraj
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ValProcessToLaunchCommand extends CommandElement {

	//This ought to be in constants now --ProcControllerIID
	private static final String procCtlrIntIID 		= "org.eclipse.tptp.processController";
	private static final String procCtlrEvntIntIID 	= "org.eclipse.tptp.processController";
		
	protected String 	_exe		= null;
	protected String 	_location	= null;
	protected boolean 	_processValidated = false;
	protected String 	_validappRes = null;
	protected String 	_validworkingDirRes = null;
	protected String 	_commandData	= null;		
	protected boolean	processTerminated = false;
			
	public ValProcessToLaunchCommand(String exe, String location)
	{
		this._exe = exe;
		this._location = location;
		this._commandData = new String();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getSize()
	 */
	public int getSize() 
	{
		return 0;
	}
	public long getContext() 
	{
		return _context;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setContextID(java.lang.String)
	 */
	public void setContext(long contextID) {
		_context = contextID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getSrcID()
	 */
	public long getSource() {
		return _src;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setSrcID(java.lang.String)
	 */
	public void setSource(long srcID) {
		_src = srcID;
	}
	//No TAG for TPTP 4.0
	public long getTag() {
		return _tag;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.impl.commands.AgentDetailsCommand#setCommand(java.lang.String)
	 */
	public void setCommandData(String command) {
		_commandData = new String(command);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.impl.commands.AgentDetailsCommand#getCommandData()
	 */
	public String getCommandData() {
		return this._commandData;
	}

	public long getDestination() {
		return _dest;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#getInterfaceID()
	 */
	public String getInterfaceID() {
		return _iid;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#setInterfaceID(java.lang.String)
	 */
	public void setInterfaceID(String interfaceID) {
		_iid = interfaceID;
	}
	
	public void setDestination(long dest) {
		_dest=dest;
	}

	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getLocation(java.lang.String)
	 */
	public String getLocation() 
	{
		return this._location;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getLocation(java.lang.String)
	 */
	public void setLocation(String location) 
	{
		this._location = location;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#setExecutable(java.lang.String)
	 */
	public void setExecutable(String exe) throws ProcessActiveException 
	{
		this._exe = exe;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.IProcess#getExecutable()
	 */
	public String getExecutable() 
	{
		return this._exe;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.execution.core.ICommandElement#buildCommand(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public String buildCommand() 
	{
		StringBuffer sbuf = new StringBuffer();
		sbuf.append("<"+Constants.validateProcessToLaunch_Cmd+" iid=\""+Constants.PROC_CTLR_IID+"\">");
		sbuf.append("<applicationName>"+this._exe+"</applicationName>");
		sbuf.append("<workingDir>"+this._location+"</workingDir>");
		sbuf.append("</"+Constants.validateProcessToLaunch_Cmd+">");
		return sbuf.toString();
	}
	/**
	* Read the command from the input buffer.
	* @return int
	* @param buffer byte[]
	* @param offset int
	*/
	public int readFromBuffer(byte[] buffer, int offset)
	{
		int current=offset;
		return current;
	}

	/**
	* Write the XML Command to the input buffer.
	* @return int
	* @param buffer byte[]
	* @param offset int
	*/
	public int writeToBuffer(byte[] buffer, int offset)
	{
		int current=offset;
		current=TPTPMessageUtil.writeTPTPStringToBuffer(buffer, current, new TPTPString(this.buildCommand()));
		return current;
	}

}
