/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseAgent.java,v 1.19 2008/03/21 23:52:14 jkubasta Exp $
 * 
 * Contributors: 
 * Navid Mehregani, IBM - Initial Implementation
 * Guru Nagarajan, Intel - Modified to provide DataChannel, ProcessCommand, Command services
 **********************************************************************/
package org.eclipse.tptp.platform.execution.datacollection;

import java.util.Hashtable;
import java.util.Vector;

import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.internal.IBaseAgentMonitorListener;
import org.eclipse.tptp.platform.execution.client.core.IProcess;
import org.eclipse.tptp.platform.execution.exceptions.AgentControllerUnavailableException;
import org.eclipse.tptp.platform.execution.exceptions.AgentCreationException;
import org.eclipse.tptp.platform.execution.exceptions.InactiveAgentException;
import org.eclipse.tptp.platform.execution.exceptions.NativeLibraryNotFound;
import org.eclipse.tptp.platform.execution.util.ICommandElement;
import org.eclipse.tptp.platform.execution.util.ICommandFragment;
import org.eclipse.tptp.platform.execution.util.ICommandHandler;
import org.eclipse.tptp.platform.execution.util.TPTPAgentAccess;
import org.eclipse.tptp.platform.execution.util.internal.CommandFragment;
import org.eclipse.tptp.platform.execution.util.internal.Constants;

/**
 * @see org.eclipse.tptp.platform.execution.datacollection.IBaseAgent
 * @author 
 *
 */
public class BaseAgent implements IBaseAgent
{
	
	/* Whether the native impls are available; the value of this is fully
	 * known at class initialization time and is set by a static initializer 
	 * in this class.  Is immutable once set in the static initializer to
	 * avoid potential threading issues across instances of this class.
	 */
    private static final boolean nativesAvailable;
    
	/* Whether the Agent Controller is running on the local box.  A single flag allows us to streamline handshaking for
        multiple agent instances. */
	private static boolean serviceAvailable = true;  //TODO: Change the value of this to false
	
	/* Stores the agent name */
	private String _name;
	
	/* Stores the agent UUID */
	private String _agentUUID;
	
	/* Stores the instance ID of the agent */
	private int _instanceID = -1;
	
	/* True if agent registered successfully with Agent Controller; false otherwise */
	private boolean _isRegistered = false; 
	
	/* Whether the agent is registered with the Agent Controller */
    private boolean _isInitialized = false;
    
    /* Process of the agent */
    private long _agentProcess;
    
    /* The number of agents */
    private static int agentCount = 0;
	
	/* Listeners for remote clients */
 	protected final Vector clientListeners = new Vector();
	
	/* Listeners for monitor listeners Will come into play when we do the Peer monitoring*/
	protected final Vector monitorListeners = new Vector(); 
	
    /*Listeners for Events */
    protected Hashtable eventListeners;
    
    /* Client List will store client ID and access level*/
    protected Vector clientList = new Vector();
    
    /* Try and load the native library.  If this fails we will ignore the error; */
    static{
        boolean nativesLoadable = false;
        try 
        {
           	System.loadLibrary("javaBaseAgent");
           	nativesLoadable = true;
        }
        catch (Throwable e) 
        {
        	if (Constants.TPTP_DEBUG) System.err.println("ERROR:- The Java base agent library was not loaded.");
        	e.printStackTrace();
        }
        nativesAvailable = nativesLoadable;
    }
    
    
    /* Native methods */
    /**
     * Native initialization of the agent
     */
    private native int initializeEngine0(String name) throws AgentControllerUnavailableException;
    
    /**
     * Native function for registering the agent with the given name and type
     */
    private native int register0(String name);
    
    private native void setProcessID0(long processID);
    //Not required call back  to jtermination
    //private native void waitForTermination0();
    /**
     * Native function for deregistering an agent
     */
    private native int deregister0();
    /**
     * Native function for getting the agent ID
     */
    private native int getAgentID0();
    /**
     * Native function for sending data 
     */
    private native int sendData0(int targetInstanceId, char[] buffer, int bufferLength);
    
    /**
      * Native function for sending data 
      */
    private native int sendData1(int targetInstanceId, byte[] buffer, int offset, int length);
    
    /**
     * Native function for sending a command to the Agent Controller
     */
    private native int sendCommand0(String command) throws InactiveAgentException;
    
    /**
     * Native function for processing the given command
     */
    private native int processCommand0(ICommandFragment command);
    
    private native int removeEventListener0(String eventsIID, int listenerID, int replyDest, int replyContext);
    private native int sendEventNotifications0(ICommandFragment cmd);
    
    private native int addEventListener0(String eventsIID, int listenerID, int replyDest, int replyContext);

	private native void processCommandLine0(String[] argv);
    
    public BaseAgent(String name) 
    {
        setName(name);        
        eventListeners = new Hashtable();
    }
    
    public void init() throws NativeLibraryNotFound 
	{
		/* If we could not load the .dll we need to throw an exception */
    	if(!nativesAvailable){throw new NativeLibraryNotFound(Constants.TPTP_PLATFORM_EXEC_MSG41);}
    	
        if (!_isInitialized) 
        {
            try
            {
                int ret = this.initializeEngine0(_name);
                if(ret == -1)
                {
                    serviceAvailable = false;    
                }
                else
                {
                    _isInitialized = true;
                }
            }
            catch(Exception e)
            {
                e.printStackTrace();
            }
        }
        if (!serviceAvailable) 
        {
            throw new NativeLibraryNotFound(Constants.TPTP_PLATFORM_EXEC_MSG41);
        }
	}
    public int preRegisterInitialization() throws AgentControllerUnavailableException
    {
        int retVal = 0;
        return retVal;
    }
    public int register() throws AgentControllerUnavailableException
    {
    	if(!_isInitialized) {
    		throw new AgentInitializationException("The agent has not been initialized. Invoke the init() method before register() is called.");
    	}
    	
        int retVal = -1;
        try 
        { 
            retVal = preRegisterInitialization();
        }
        catch(Exception e){e.printStackTrace(); return retVal;}
        if(retVal == -1){throw new AgentControllerUnavailableException(Constants.TPTP_PLATFORM_EXEC_MSG42);}
		retVal = this.register0(this._name);
		if(retVal == 0){this._isRegistered = true;}
		//TODO: Bugzilla - the semaphore has no timeout so the following call will never happen - GN
		else { this._isRegistered = false; throw new AgentControllerUnavailableException(Constants.TPTP_PLATFORM_EXEC_MSG42);}
		
		if(_isRegistered)
		{
		    //Get the AgentConn Id
		    int agentID = this.getAgentID0();
		    if(agentID == -1)
		    {
		        throw new AgentControllerUnavailableException(Constants.TPTP_PLATFORM_EXEC_MSG42);
		    }
		    this.setAgentID(agentID);
		    if(Constants.TPTP_DEBUG)System.out.println("Agent Instance ID " + this.getAgentID());
		}
		return retVal;
	}
    
    public int deregister() 
	{
		int deregisterResponse = -1;
        if (this._isInitialized) 
        {
            deregisterResponse = this.deregister0();
            if(deregisterResponse == -1)
            {
                if(Constants.TPTP_DEBUG)System.out.println("Unable to deregister the agent");
            }
            this._isInitialized = false;
        } //Deregister

        this._isRegistered = false; 
		return deregisterResponse;
	}
    
   	/**
	 * @see IBaseAgent#isRegistered()
	 */
	public boolean isRegistered() 
	{
		return _isRegistered;
	}

	public void finalize() 
    {
        try 
        {
            this.deregister0();
        } 
        finally 
        {
            try {super.finalize();}
            catch (Throwable t) {}
        }
    }

	public void processCommand(ICommandFragment command) 
	{
		String commandName = ((CommandFragment)command).getCommandName();
		//TODO: Move the tptp.Agent interface to constants
		if (((CommandFragment)command).getInterfaceID().equals("org.eclipse.tptp.Agent"))
		{
			if (commandName.equals("terminate"))
			{
			    //clean up finalize -- terminate
			}
			else if (commandName.equals("notifyReference"))
			{
			    //Loop through the values and add the client
				//this.addClient(clientID, cal);
			}
			else if (commandName.equals("notifyDereference"))
			{
				 //this.removeClient(clientID);
			}
			else  // Unrecognized command
			{
				//return invaliderror
			}
		} 
		else if
		(((CommandFragment)command).getInterfaceID().equals(Constants.AGNT_MGR_IID))
		{
			// Handle the agentRegistered response from the agentManager interface
			// which marks the completion of the registerAgent command.
			if (commandName.equals("agentRegistered"))
			{
				//TODO:clean this  captured in the register agent call 
			}
			else if (commandName.equals("agentDeregistered"))
			{
				
			}
			else  // Unrecognized command
			{
				//Do nothing
			}
		} else	// Unrecognized interface
		{
			//Do nothing
		}
	}

	/**
	 * @see IBaseAgent#sendData(int, char[], int)
	 */
	public int sendData(int targetInstanceId, char[] buffer) throws AgentControllerUnavailableException 
	{
		int response = this.sendData0(targetInstanceId, buffer, buffer.length);
		if(response == -1){throw new AgentControllerUnavailableException(Constants.TPTP_PLATFORM_EXEC_MSG43);}
		return response;
	}
	
	/**
	 * @throws AgentControllerUnavailableException 
	 * @see IBaseAgent#sendData(int, byte[])
	 */
	public int sendData(int targetInstanceId, byte[] buffer) throws AgentControllerUnavailableException {
		if (buffer == null) return 0;
		return sendData (targetInstanceId, buffer, 0, buffer.length);
	}
	
	/**
	 * @see IBaseAgent#sendData(int, byte[], int, int)
	 */
	public int sendData(int targetInstanceId, byte[] buffer, int offset, int length) throws AgentControllerUnavailableException {
		int response = sendData1(targetInstanceId, buffer, offset, length);
		if(response == -1) throw new AgentControllerUnavailableException(Constants.TPTP_PLATFORM_EXEC_MSG43);
		return response;
	}
	
	/**
	 * @see IBaseAgent#receiveData(int, char[], int)
	 */
	public int receiveData(int sourceId, String buffer, int bufferLength) 
	{
	    //TO DO: At this point printing the data
	    System.out.println("Data Recvd. on the data channel");
	    System.out.println("*******************************");
	    System.out.println(buffer);
	    System.out.println("*******************************");
		return 0;
	}
	
	/**
	 * @see IBaseAgent#receiveData(int, byte[], int)
	 */
	public int receiveData(int sourceId, byte[] buffer, int bufferLength) {
	    System.out.println(String.valueOf(bufferLength) + " bytes recvd. on the data channel");
		return 0;
	}

	/**
	 * @see IAgent#getName()
	 */
	public String getAgentName() 
	{
		return this._name;		
	}

	/**
	 * @see IAgent#setName(String)
	 */
	public void setName(String name) 
	{
		this._name = name;		
	}

	/**
	 * @see IAgent#getUUID()
	 */
	public String getUUID() 
	{
		return this._agentUUID;
	}
	public void waitForTermination()
	{
	    //This forces termination of all threads in the Java virtual machine
	    System.exit(1);
	}
	/**
	 * @see IAgent#setUUID(String)
	 */
	public void setUUID(String uuid) 
	{
		this._agentUUID = uuid;		
	}

	/**
	 * @see IAgent#getAgentInstanceId()
	 */
	public int getAgentID() 
	{
		return _instanceID;
	}

	/**
	 * @see IAgent#setAgentInstanceId(int)
	 */
	private void setAgentID(int id) 
	{
		this._instanceID = id;		
	}

	/**
	 * @see IAgent#getProcess()
	 */
	public long getProcessID() 
	{
	    long pid = 0;
		return pid;
	}
	
	public void setSupportedInterfaces(String[] interfaceID)
	{
	    //TODO:should be this be an internal interface list or the external one
	    //the validation should be in init()
	}
	/**
	 * @see IAgent#setProcess(IProcess)
	 */
	void setProcessID(long processID) {
		_agentProcess = processID;
	}
	private void addClient(int clientConnId, int accessMode)
	{
	    TPTPAgentAccess am = null;
	    if(accessMode == TPTPAgentAccess.TPTP_CONTROLLER_ACCESS.getValue())
	    { am = TPTPAgentAccess.TPTP_CONTROLLER_ACCESS;}
	    
	    if(accessMode == TPTPAgentAccess.TPTP_OBSERVER_ACCESS.getValue())
	    { am = TPTPAgentAccess.TPTP_OBSERVER_ACCESS;}
	    
	    if (am == null){ am = TPTPAgentAccess.TPTP_OBSERVER_ACCESS;}
	    this.addClient(clientConnId, am);
	}
	
	public void addClient(int clientConnId, TPTPAgentAccess accessMode)
	{
	    ClientList cl = new ClientList(clientConnId,accessMode);
	    synchronized(clientList)
	    { 
	        boolean found = false;
	        for(int i = 0; i < clientList.size();i++)
	        {
	            if(((ClientList)clientList.elementAt(i)).getClientID() == clientConnId)
	            {
	                found = true;
	                break;
	            }
	        }
	        if(!found)clientList.add(cl);
	    }
	   
	}
	/**
	 * @see IAgent#removeEventListener(String, ICommandHandler)
	 */
	public int removeEventListener(String eventsIID, int listenerID, int replyDest, int replyContext)
	{
	    int ret = -1;
		synchronized(clientListeners) 
		 {
			 for(int i = 0; i < clientListeners.size(); i++) 
			 {
			    if(((ClientListener)clientListeners.elementAt(i)).getEventIntID().equals(eventsIID)) 
			    {
			    	if((((ClientListener)(clientListeners.elementAt(i))).getListenerID()==listenerID))
			    	{
			    	    if((((ClientListener)(clientListeners.elementAt(i))).getDestID()==replyDest))
			    	    {
			    	        clientListeners.removeElementAt(i);
			    	    }
			    	}
			    }
			 }
		 } //synchronize
		return ret;
	}
	public int addEventListener(String eventsIID, int listenerID, int replyDest, int replyContext)
	{
	    StringBuffer response = new StringBuffer();
	    if (eventsIID != null && listenerID != -1 && replyDest != -1)
	    {
	        ClientListener clientlstnr = new ClientListener(eventsIID,listenerID,replyContext);
	        response.append("<Cmd src="+"\""+this.getAgentID()+"\" dest=\""+replyDest+"\" ctxt=\""+replyContext+"\">");
	        response.append("<listenerAccepted iid=\""+Constants.GENERIC_EVNT_IID+"\"></listenerAccepted></Cmd>");
	        synchronized(clientListeners)
	        {
	            boolean found = false;
				 for(int i = 0; i < clientListeners.size(); i++) 
				 {
				    if(((ClientListener)clientListeners.elementAt(i)).getEventIntID().equals(eventsIID)) 
				    {
				    	if((((ClientListener)(clientListeners.elementAt(i))).getListenerID()==listenerID))
				    	{
				    	    if((((ClientListener)(clientListeners.elementAt(i))).getDestID()==replyDest))
				    	    {
				    	        found = true;
				    	        break;
				    	    }
				    	}
				    }
				 }
				 if(!found)clientListeners.add(clientlstnr);		         
	        }
	        try
		    {
	            this.sendCommand(response.toString());
		    }
		    catch(Exception e){e.printStackTrace(); return -1;}
	    }

	    return 0;
	}
	public int sendEventNotifications(ICommandFragment cmd) throws AgentControllerUnavailableException
	{
	    int ret = sendEventNotifications0(cmd);
	    return ret;
	}
	public String getConfigValue()
	{
	    //TODO:getConfigValue
	    return null;
	}
	/**
	 * @see IAgent#sendCommand(ICommandElement, ICommandHandler)
	 */
	public void sendCommand(ICommandFragment outCommand) throws AgentControllerUnavailableException 
	{
		// TODO :ICommandElement does not make commandName available for  this.sendCommand0(outCommand.wr);  I believe APIs should be changed 
	}
	
	public void sendCommand(String outCommand) throws AgentControllerUnavailableException 
	{
	    try
	    {
	        this.sendCommand0(outCommand);
	    }
	    catch(Exception e){e.printStackTrace();}
	}

	public int processEventProviderCommands(ICommandFragment cmd)
    {
        return 0;
    }
	public int processDataProviderCommands(ICommandFragment cmd)
    {
        return 0;
    }
	/**
	 * @see IBaseAgent#getVersion()
	 */
	
	public void removeClient(int clientConnId)
	{
	    synchronized(clientList)
	    { 
	        for(int i = 0; i < clientList.size();i++)
	        {
	            if(((ClientList)clientList.elementAt(i)).getClientID() == clientConnId)
	            {
	                clientList.removeElementAt(i);
	            }
	        }
	    }
	}
	/**
	 * Retrieve the interfaces supported by the Agent
	 * <B>Interface: </B>
	 * @return String[]
	 */
	public String[] getSupportedInterfaces()
	{
	    String[] agentInterfaces = null;
	    return agentInterfaces;
	}
	/**
	 * Will need this for the Peer - will visit later - Guru
	 */
	public void addMonitorListener(IBaseAgentMonitorListener listener) 
	{
		synchronized(monitorListeners) 
		{
			if(!monitorListeners.contains(listener)) 
			{
				monitorListeners.add(listener);
			}
		}
	}
	/**
	 * @see IBaseAgent#removeMonitorListener(IRemoteMonitorListener)
	 */
	public void removeMonitorListener(IBaseAgentMonitorListener listener) 
	{
		synchronized(monitorListeners) 
		{
			if(monitorListeners.contains(listener)) 
			{
				monitorListeners.remove(listener);
			}	
		}
	}

	public void processCommandLine(String[] argv) {
	    try {
	        processCommandLine0(argv);
	    }
	    catch(Exception e){
	    }
	}

//    /**
//     * Called by the native implementation to indicate that the agent
//     * is now registered with the Agent Controller.
//     */
//    private void agentControllerActive() {
//        serviceAvailable = true;
//        uuidsValid = true;
//
//        synchronized (this.getClass()) {
//            if (agentCount == 0) {
//                this.getClass().notify();
//            }
//        }
//
//        synchronized(serverListeners) {
//        	Enumeration e=serverListeners.elements();
//        	while(e.hasMoreElements()) {
//        		AgentControllerListener listener=(AgentControllerListener)e.nextElement();
//        		listener.agentControllerActive();
//        	}
//        }
//    }
//
//    /**
//     * Called by the native implementation to indicate that the agent is no longer
//     * registered with the Agent Controller.  At the same time the IRemoteExecutionComponent's default configuration
//     * is destroyed as it may be changed by the Agent Controller before the next time we re-register.
//     */
//    private void agentControllerInactive() {
//        serviceAvailable = false;
//        setLogging(false);
//       	_defaultConfiguration.clear();
//        synchronized(serverListeners) {
//        	Enumeration e=serverListeners.elements();
//        	while(e.hasMoreElements()) {
//        		AgentControllerListener listener=(AgentControllerListener)e.nextElement();
//        		listener.agentControllerInactive();
//        	}
//        }
//    }
//
//    /**
//     * Called by the native implementation to indicate that the agents
//     * remotely attached client has either detached from the agent or
//     * that the client has died.
//     */
//    private void remoteClientExited() {
//        setLogging(false);
//        synchronized(clientListeners) {
//        	Enumeration e=clientListeners.elements();
//        	while(e.hasMoreElements()) {
//        		RemoteClientListener listener=(RemoteClientListener)e.nextElement();
//        		listener.clientInactive();
//        	}
//        }
//    }
//    
//    /**
//     * This is called by the native code to turn logging
//     * "on" or "off".  When turned "off" there is no stepping
//     * through the JNI boundary.
//     */
//    private synchronized void setLogging(boolean log) {
//        isLogging = log;
//        synchronized(monitorListeners) {
//        	Enumeration e=monitorListeners.elements();
//        	while(e.hasMoreElements()) {
//        		MonitorListener listener=(MonitorListener)e.nextElement();
//        		if (isLogging) {
//        			listener.monitorActive();
//            		}
//            		else {
//                		listener.monitorInactive();
//            		}
//            	}
//        }
//        if (isLogging && requestForMonitor) {
//            synchronized (this) {
//                this.notify();
//            }
//        }
//
//    }
//    
//    private void incomingCommand(CommandElement command) {
//    	if(command instanceof CustomCommand) {
//	 		synchronized(commandListeners) {
//				Enumeration e=commandListeners.elements();
//				while(e.hasMoreElements()) {
//					CustomCommandHandler listener=(CustomCommandHandler)e.nextElement();
//					listener.handleCommand((CustomCommand)command);
//				}
//	 		}
//    	}
//    }
}
class ClientListener
{
    private String 		eventInterfaceID;
    private int			listenerID;
    private int			destID;
    
    public ClientListener(String eventInterfaceID, int listenerID, int destID)
    {
        this.eventInterfaceID = eventInterfaceID;
        this.listenerID		  = listenerID;
        this.destID			  = destID;
    }
    public String getEventIntID()
    {
        return this.eventInterfaceID;
    }
    public int getListenerID()
    {
        return this.listenerID;
    }
    public int getDestID()
    {
        return this.destID;
    }
}
class ClientList
{
    private int						clientID;
    private TPTPAgentAccess			accessMode;
    
    public ClientList(int clientID, TPTPAgentAccess accessMode)
    {
        this.clientID		  = clientID;
        this.accessMode		  = accessMode;
    }
    public int getClientID()
    {
        return this.clientID;
    }
    public TPTPAgentAccess getAccessMode()
    {
        return this.accessMode;
    }
}

class AgentInitializationException extends RuntimeException {

	public AgentInitializationException(String message) {
		super(message);
	}
}
