/*******************************************************************************
 * Copyright (c) 2005 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: IVariableProvider.java,v 1.3 2005/10/04 01:31:53 gnagarajan Exp $ 
 *******************************************************************************/ 

package org.eclipse.tptp.platform.execution.datacollection;

import org.eclipse.tptp.platform.execution.util.Variable;
import org.eclipse.tptp.platform.execution.util.VariableGroup;

/**
 * The Variable Provider interface provides the interface 
 * for setting and retrieving the values of Variables that the Agent 
 * exports
 *
 * @since tptp 4.0 
 * @provisional 
 * 
 */

public interface IVariableProvider
{
	//get group structure
	/** 
	 * Get the root variable group (full configuration) alongwith all the sub groups and variables 
	 */
    public VariableGroup getRootVariableGroup();
    
    /** 
     * Get the Variable Group alongwith the sub groups and variables
     * @param id
     */
    public VariableGroup getVariableGroup(int id);
    
    /** 
     * Sets the Variable Group values
     * @param variableGroup 
     */
    public void setVariableGroup(VariableGroup variableGroup);

    //get variables
    /** 
     * Get all variables 
     * @return Variable[]
     */
    public Variable[] getVariables();
    
    /** 
     * Get the value of a specific variable 
     * @param varid
     * @return Variable
     */
    public Variable getVariable(int varid);
    
    
    /** 
     * Get the Variables values of the variable list supplied as parameter
     * @param varids
     * @return Variable[] 
     */
    public Variable[] getVariablesById(int[] varids);
    

    //atomically get/set multiple variables
    /** 
     * Get multiple variables
     * @return Variable[] 
     */
    public Variable[] getVariableValues();// throws AccessException;
    
    /** 
     * Set multiple variables
     * @param variables 
     */
    public void setVariableValues(Variable[] variables);// throws BadTypeException, BadValueException, AccessException;
    
    /**
     * Get single variable value
     * @return Variable
     */
    public Variable getVariableValue();//throws AccessException;
    
    /**
     * Set single variable value
     * @param variable
     */
    public void setVariableValue(Variable variable);//throws BadTypeException, 
}