/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *
 * $Id: RemoteInvocationException.java,v 1.5 2006/01/27 17:40:40 akaylor Exp $ 
 *******************************************************************************/ 

package org.eclipse.tptp.platform.execution.exceptions;


/**
 * Methods that can be remotely invoked should declare this exception
 * in the <code>throws</code> clause.
 * 
 * @since tptp 0.0.2 (no change)
 * 
 */

public class RemoteInvocationException extends RuntimeException {
	
	private static final long serialVersionUID = 1L;

	protected Throwable cause;

	/**
	 * @param message a description of the condition that caused this exception
	 *        to be thrown
	 */
	public RemoteInvocationException(String message) {
		super(message);
	}
	
	/**
	 * @param message a description of the condition that caused this exception
	 *        to be thrown
	 * @param cause a <code>Throwable</code> that represents the underlying cause
	 *        of this exception having been thrown
	 */
	public RemoteInvocationException(String message, Throwable cause) {
		super(message);
		this.cause = cause;
	}
	
	/**
	 * @param cause a <code>Throwable</code> that represents the underlying cause
	 *        of this exception having been thrown
	 */
	public RemoteInvocationException(Throwable cause) {
		this.cause = cause;
	}

	/**
	 * @return a <code>Throwable</code> that represents the underlying cause of
	 *         this exception having been thrown
	 */	
	public Throwable getCause() {
		return cause;
	}

}
