/*******************************************************************************
 * Copyright (c) 2005, 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: SampleClientAC.java,v 1.20 2006/02/10 22:12:31 vnaikawadi Exp $ 
 *******************************************************************************/ 


package org.eclipse.tptp.platform.execution.samples;

import org.eclipse.tptp.platform.execution.client.agent.*;
import org.eclipse.tptp.platform.execution.client.core.*;
import org.eclipse.tptp.platform.execution.util.*;
/**
 * This sample connects to an Agent Controller running on the local host
 * and creates a type of agent called collector.
 * The client sends commands to the collector to start and stop execution.
 * During the period when the collector is running, data is collected by the collector.
 * The data collected by the collector is then recieved by the client.
 * @author gnagaraj
 *
 */

public class SampleClientAC
{

	public static void main(String[] args)
	{
	    //Connect to the host where the Agent Controller is running
	    //See the Getting started guide for TPTP 4.0 
		String localhost = "localhost";
		//This port number corresponds to the port where the Agent Controller
		//listens/accepts connections. This is defined in the Agent Controller
		//serviceconfig.xml file in the <AgentController_INSTALL_HOME>/config
		int port = 10006;
		System.out.println("Connecting to Host "+ localhost);
		// Get the Command Line Parameters
		if (args.length > 0)
		{
			if (args.length >= 1)
			{
				localhost = args[0];
			}
			if (args.length >=2)
			{
				port = (new Integer(args[1])).intValue();
			}
		}
		
		//Create a Node that represents the target agent controller
		INode SampleNode = null;
		//Create the client Agent Controller representation object
		IAgentController ac = null;
		//Pass the connection info the client
		ConnectionInfo connInfo = new ConnectionInfo();
		
		try
		{
			//Create a Node that represents the target machine and agent controller
			SampleNode = NodeFactory.createNode(localhost);
			
			//Set the connection parameters required 
			connInfo.setHostName(localhost);
			connInfo.setPort(port);
			//connInfo.setAgentControllerNew(true);

			if (SampleNode != null)
			{
				// Connect to the Agent Controller, a successful connection returns 
			    //a client side Agent Controller object that provides various 
			    //methods to perform TPTP tasks.
				System.out.println("Connecting to AC..");
				ac = SampleNode.connect(connInfo);
				
				System.out.println("Connected to " + localhost + " at port number " + port);

				//Create an Agent representation on the client to hold Agent information
				//In this case a Collector object is created. A collector is a type of an Agent
				//The Agent Controller creates an instance of the Collector
				//and returns an agent reference that allows the client to perform operations on the collector.
				ICollector TCollector = (ICollector)ac.getAgent("org.eclipse.tptp.TimeCollector", "org.eclipse.tptp.platform.execution.client.agent.ICollector");
				
				if(TCollector == null){System.out.println("Agent not available, configure the agent and retry"); return;}
				
				//Create the Data Connection required to recieve response from the collector;
				//The input to startMonitoring is the to establish the data connection between the client and 
				//the agent controller for the direction of data flow.
				//See constants for additional values.
				((IAgent)TCollector).startMonitoring(TPTPDataPath.DATA_PATH_TWO_WAY);
				
				((IAgent)TCollector).addDataListener( new IDataProcessor()
						{
							public void incomingData(byte[] buffer, int length, java.net.InetAddress peer)
							{
								String data = new String(buffer);
								System.out.println("The Data received from TimeCollector - " + data.trim());
							}
							
							public void incomingData(char[] buffer, int length, java.net.InetAddress peer)
							{
								System.out.println("Char Data Processor Called");
							}
							
							public void invalidDataType(byte[] data, int length, java.net.InetAddress peer)
							{
								System.out.println("Data Processor Invalid Data Type Called");
							}
							
							public void waitingForData()
							{
								System.out.println("Data Processor Waiting for Data Called");
							}
						});				
				
				//Send a message to Agent
				TCollector.run();
				TCollector.sendData("HELLO from org.eclipse.tptp.platform.execution plugin".getBytes());
				//Wait for the response to arrive
				Thread.sleep(2000);
				
				TCollector.stop();
			
				Thread.sleep(1000); 
				// Disconnect from AC				
				ac.disconnect();
			}
			else
			{
				System.out.println("Error occurred while creating the Node for " + localhost);
			}
			
		}
		catch(Exception exp)
		{
			System.out.println("Error occurred while connecting to " + localhost + ":" + exp);
		}		
	}
}
