package org.eclipse.tptp.platform.execution.samples;

import org.eclipse.tptp.platform.execution.client.core.ConnectionInfo;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.IFileTransferManager;
import org.eclipse.tptp.platform.execution.client.core.INode;
import org.eclipse.tptp.platform.execution.client.core.NodeFactory;

/*******************************************************************************
 * Copyright (c) 2006 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Randy D. Smith,Intel - Initial implementation
 *$Id: SampleFileTransferAC.java,v 1.8 2006/11/07 06:25:46 gnagarajan Exp $
 *******************************************************************************/ 

public class SampleFileTransferAC {


	public SampleFileTransferAC()
	{

	}

	public static void main(String[] args)
	{
		String localhost = "localhost";
		//This port number corresponds to the port where the Agent Controller
		//listens/accepts connections. This is defined in the Agent Controller
		//serviceconfig.xml file in the <AgentController_INSTALL_HOME>/config
		int port = 10006;
		
		String localFile = "C:\\Same.txt";
		String remoteFile = "C:\\Simple.txt";
		String localFile1 = "C:\\big_dupe1.txt";
		// Currently big_simple is 258*512 bytes big (132096 bytes)
		String remoteFile1 = "C:\\big_simple.txt"; // NEEDS TO BE THERE PRE-TEST
		// We'll try a putFile of an exact multiple of blocks also (132096 bytes)
		String putFile2 = "C:\\big_simple.txt";
		String remoteFile2 = "C:\\big_dupe2.txt";
		String putFile3 = "C:\\temp\\test.zip"; // NEEDS TO BE THERE PRE_TEST; binary!
		String remoteFile3 = "C:\\put_dupe3.zip";
		String putFile4 = "C:\\small.txt"; // LESS THAN A BLOCK IN SIZE
		String remoteFile4 = "C:\\put_dupe4.txt";
		String putFile5 = "C:\\empty.foo"; // SIZE 0
		String remoteFile5 = "C:\\put_dupe5.foo";
		// Can exist, or not, depending on what you are trying to test!
		String deleteFile = "C:\\temp\\test2.zip";
		
		// Get the Command Line Parameters
		if (args.length > 0)
		{
			if (args.length >= 1)
			{
				localFile = args[0];
			}
			if (args.length >= 2)
			{
				remoteFile = args[1];
			}
			if (args.length >= 3)
			{
				localhost = args[0];
			}
			if (args.length >= 4)
			{
				port = (new Integer(args[1])).intValue();
			}
		}

		
		//Create a Node that represents the target machine and agent controller
		INode node = null;
		IAgentController agentController = null;
		ConnectionInfo connectionInfo = new ConnectionInfo();
		
		try
		{
			//Create a Node that represents the target machine and agent controller
			
			node = NodeFactory.createNode(localhost);
			connectionInfo.setHostName(localhost);
			connectionInfo.setPort(port);
			//connectionInfo.setAgentControllerNew(true);
			if (node != null)
			{
				// Connect to the Agent Controller
				System.out.println("Connecting to AC..");
				agentController = node.connect(connectionInfo);
				System.out.println("Connected to " + localhost + " at port number " + port);

				// Get the file manager via the Agent Controller
				IFileTransferManager fileTransferManager = agentController.getFileTransferManager();
				
				// Get a file
				fileTransferManager.getFile(localFile1, remoteFile1);

				// Put a file
				fileTransferManager.putFile(putFile2, remoteFile2);
				
				// Put another
				fileTransferManager.putFile(putFile3, remoteFile3);
				
				// ...and another
				fileTransferManager.putFile(putFile4, remoteFile4);
				
				// ...and finally
				fileTransferManager.putFile(putFile5, remoteFile5);

				// Delete a remote file
				fileTransferManager.deleteFile(deleteFile);
				while(true)
				{
					Thread.sleep(1000);
					break;
				}
				System.out.println("All the above file operations completed successfuly");
			}
			else
			{
				System.out.println("Error occurred while creating the Node for " + localhost);
			}
			
		}
		catch(Exception exp)
		{
			System.out.println("Error occurred while connecting to " + localhost + ":" + exp);
		}		
	}

}
