/*******************************************************************************
 * Copyright (c) 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Igor Alelekov, Intel - initial API and implementation
 *    
 * $Id: SecureClientAC.java,v 1.2 2007/09/06 11:47:47 jkubasta Exp $
 *
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.samples;

import org.eclipse.tptp.platform.execution.client.agent.*;
import org.eclipse.tptp.platform.execution.client.core.*;
import org.eclipse.tptp.platform.execution.security.User;
import org.eclipse.tptp.platform.execution.util.*;

public class SecureClientAC {
	public final static String HOST = "localhost";
	public final static int PORT = 10006;
	
	public static void main(String[] args) {
		ConnectionInfo connInfo = null;
		IAgentController ac = null;
		INode node = null;

		System.out.println("Connecting to Agent Controller\n");

		try {
			node = NodeFactory.createNode(HOST);
			//Set the connection parameters required 
			connInfo = new ConnectionInfo();
			connInfo.setHostName(HOST);
			connInfo.setPort(PORT);

			ac = node.connect(connInfo);
		} catch (Exception e) {
			System.out.println("Error occurred while connecting to " + HOST + ":" + e);
		}

		if (ac == null) return;

		System.out.println("Connected to " + HOST + ":" + PORT);
		
		while (!ac.isAuthenticated()) {
			User user = getUser();
			if (user == null) {
				System.out.println("\nAuthentication failed");
				break;
			}
			
			try {
				ac = node.connect(connInfo, user);
			} catch (Exception e) {
				System.out.println("ex " + e);
			}
		}

		if (!ac.isAuthenticated()) {
			ac.disconnect();
			return;
		}
		
		try {
			ICollector timeCollector = (ICollector) ac.getAgent("org.eclipse.tptp.TimeCollector", "org.eclipse.tptp.platform.execution.client.agent.ICollector");
			if(timeCollector == null) {
				System.out.println("Agent not available, configure the agent and retry");
				ac.disconnect();
				return;
			}
				
			//Create the Data Connection required to recieve response from the collector;
			//The input to startMonitoring is the to establish the data connection between the client and 
			//the agent controller for the direction of data flow.
			//See constants for additional values.
			timeCollector.startMonitoring(TPTPDataPath.DATA_PATH_TWO_WAY);
			timeCollector.addDataListener(new IDataProcessor() {
				public void incomingData(byte[] buffer, int length, java.net.InetAddress peer) {
					String data = new String(buffer, 0, length);
					System.out.println("The Data received from TimeCollector - " + data.trim());
				}
							
				public void incomingData(char[] buffer, int length, java.net.InetAddress peer) {}
				public void invalidDataType(byte[] data, int length, java.net.InetAddress peer) {}
				public void waitingForData() {}
			});				
				
			//Send a message to Agent
				
			timeCollector.run();
			timeCollector.sendData("HELLO from org.eclipse.tptp.platform.execution plugin".getBytes());
				//Wait for the response to arrive
				Thread.sleep(2000);
				
			timeCollector.stop();
			
			Thread.sleep(1000); 
				// Disconnect from AC				
			ac.disconnect();
			System.out.println("disconnected");				
		}
		catch(Exception exp) {
			System.out.println("Error occurred while connecting to " + HOST + ":" + exp);
		}		
	}
	
	private static User getUser() {
		byte buf[] = new byte[256];
		int n;
		
		System.out.println("\nUser authentication.");
		System.out.print("Login: ");
		try { n = System.in.read(buf); } catch (Exception e) { n = 0; }
		if (n <= 0) return null;

		String login = new String(buf, 0, n).trim();
		if (login.length() == 0) return null;
		
		System.out.print("Password: ");
		try { n = System.in.read(buf); } catch (Exception e) { n = 0; }
		if (n <= 0) return null;
		
		String psw = new String(buf, 0, n).trim();
		if (psw.length() == 0) return null;

		return new User(null, login, psw);
	}
}
