package org.eclipse.tptp.platform.execution.samples;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.agent.ICollector;
import org.eclipse.tptp.platform.execution.client.core.ConnectionInfo;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.INode;
import org.eclipse.tptp.platform.execution.client.core.NodeFactory;
import org.eclipse.tptp.platform.execution.util.TPTPDataPath;
import org.eclipse.tptp.platform.execution.client.core.internal.AgentController;

/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * This class illustrates a problem with the state of an ICollector not propogating
 * to an IAgent object.
 * 
 * Follow the steps below:
 * 
 * 1) Run a Java class using JVMTI - controlled mode: 
 * (e.g.  java -agentlib:JPIBootLoader=JPIAgent:server=controlled;CGProf StartStop)
 * 2) Run this class
 * 
 * Notice that despite monitoring the ICollector, the state of isMonitored on the associated
 * IAgent object returns false. 
 */
public class TPTPAgent
{
	public static void main(String[] args) throws Exception
	{
		final INode node = NodeFactory.createNode("localhost");
		final ConnectionInfo connInfo = new ConnectionInfo();
		
		connInfo.setHostName("localhost");
		connInfo.setPort(10002);
		
		final IAgentController ac = node.connect(connInfo);
		String[] s = {"org.eclipse.tptp.jvmti"};
		IAgent[] agents = ac.queryRunningAgents();
		IAgent tiAgent = null;
		for (int i = 0; i < agents.length; i++)
		{
			if (agents[i].getName().equals("org.eclipse.tptp.jvmti"))
			{
				tiAgent = agents[i];
				break;
			}
		}
		
		if (tiAgent == null)
		{
			System.err.println("No TI agent was found");
			return;
		}
		
		ICollector tiAgentCollector = attachToAgent(ac, tiAgent.getProcess().getProcessId());
		System.out.println("The state of the ICollector: " + tiAgentCollector.isMonitored());
		System.out.println("The state of the IAgent: " + tiAgent.isMonitored());
		
		
		System.out.println("Done!");
	}

	private static ICollector attachToAgent(IAgentController ac, long processId)
	{
		try
		{
			System.out.println("Attaching to the JVMTI agent...");
			ICollector tiAgentCollector = (ICollector)ac.getAgent("org.eclipse.tptp.jvmti", ICollector.class.getName(), processId);
			tiAgentCollector.startMonitoring(TPTPDataPath.DATA_PATH_TWO_WAY);
			tiAgentCollector.run();
			tiAgentCollector.resume();
			System.out.println("Successfully attached");		
			return tiAgentCollector;
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return null;
	}

}

