/*******************************************************************************
 * Copyright (c) 2005, 2007 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Guru Nagarajan,Intel - Initial API and implementation
 *
 * $Id: TPTPJavaAgent.java,v 1.17 2007/11/21 12:29:48 ialelekov Exp $ 
 *******************************************************************************/
package org.eclipse.tptp.platform.execution.samples;

import java.util.Date;

import org.eclipse.tptp.platform.execution.datacollection.BaseAgent;
import org.eclipse.tptp.platform.execution.util.ICommandFragment;
import org.eclipse.tptp.platform.execution.util.internal.CommandFragment;
import org.eclipse.tptp.platform.execution.util.internal.Constants;

/**
 * @author gnagaraj
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TPTPJavaAgent extends BaseAgent implements Runnable{

    public static final String TIMECOLLECTOR_INTERFACE = "org.eclipse.tptp.TimeCollector";
    protected boolean running = true;
	protected Date startTime;
	protected Date endTime;
	protected long elapsedTime = 0;
	
	/* Element Command Names used to communicate with the client */
	protected String agentRunningTag = "agentRunning";
	protected String agentStoppedTag = "agentStopped";
	protected String elapsedTimeTag = "elapsedTime";
	 
    /**
     * @param name
     * @param type
     */
    public TPTPJavaAgent(String name, String type) 
    {
        super(name);
        try
        {
            super.init();
        }
        catch (Exception e){e.printStackTrace();}
        // TODO Auto-generated constructor stub
    }

    public static void main(String[] args) 
    {
        /* Create a TimeCollector Agent */
		TPTPJavaAgent jAgent = new TPTPJavaAgent("org.eclipse.tptp.JavaTimeCollector", "Collector");
		
		/* Register agent */
		try {
			jAgent.processCommandLine(args);
		    jAgent.register();
		}
		catch(Exception e){e.printStackTrace();}
		
		Thread thread = new Thread(jAgent);
		thread.start();
    }
    
    public void processCommand(ICommandFragment cmd)
    {
        super.processCommand(cmd);
        if(Constants.TPTP_DEBUG)System.out.println("Incoming command "+((CommandFragment)cmd).getCommandName());
       
        if(((CommandFragment)cmd).getCommandName().equals("getElapsedTime"))
        {
            this.sendElapsedTimeResponse((CommandFragment)cmd);
        }
        if(((CommandFragment)cmd).getCommandName().equals("getCurrentTime"))
        {
            this.sendCurrTimeResponse((CommandFragment)cmd);
        }
        if(((CommandFragment)cmd).getCommandName().equals("stop"))
        {
            this.sendStopResponse((CommandFragment)cmd);
        }
        if(((CommandFragment)cmd).getCommandName().equals("run"))
        {
            this.sendRunResponse((CommandFragment)cmd);
        }
    }
    
    public void run()
    {
        while(running)
        {
            try { Thread.sleep(1000); } catch (Exception e) {}
        }
        /* Deregister agent */
		this.deregister();
    }

    private int sendElapsedTimeResponse(CommandFragment cmd)
    {
    	int ret = -1;
    	elapsedTime = new Date().getTime() - startTime.getTime();
    	int destID = new Long(cmd.getSource()).intValue();
    	int sourceID = this.getAgentID();
    	int contextID = new Long(cmd.getContext()).intValue();
    	StringBuffer sbuf = new StringBuffer();
    	sbuf.append("<Cmd src="+"\""+sourceID+"\"");
    	sbuf.append(" dest="+"\""+destID+"\"");
    	sbuf.append(" ctxt="+"\""+contextID+"\">");
    	sbuf.append("<"+elapsedTimeTag+" iid=\""+TIMECOLLECTOR_INTERFACE+"\">");
    	sbuf.append("<time>"+elapsedTime+"</time>");
    	sbuf.append("</"+elapsedTimeTag+">"+"</Cmd>");
    	
    	try
    	{
    	    super.sendCommand(sbuf.toString());
    	    ret = 0;
    	}
    	catch(Exception e){e.printStackTrace();}

    	return ret;
    }
    
    private int sendRunResponse(CommandFragment cmd)
    {
    	int ret = -1;
    	startTime = new Date();
    	int destID = new Long(cmd.getSource()).intValue();
    	int sourceID = this.getAgentID();
    	int contextID = new Long(cmd.getContext()).intValue();
    	StringBuffer sbuf = new StringBuffer();
    	sbuf.append("<Cmd src="+"\""+sourceID+"\"");
    	sbuf.append(" dest="+"\""+destID+"\"");
    	sbuf.append(" ctxt="+"\""+contextID+"\">");
    	sbuf.append("<"+agentRunningTag+" iid=\""+TIMECOLLECTOR_INTERFACE+"\">");
    	sbuf.append("</"+agentRunningTag+">"+"</Cmd>");
    	
    	try
    	{
    	    System.out.println("Run response "+sbuf.toString());
    	    super.sendCommand(sbuf.toString());
    	    ret = 0;
    	}
    	catch(Exception e){e.printStackTrace();}

    	return ret;
    }

    private int sendCurrTimeResponse(CommandFragment cmd)
    {
    	int ret = -1;
    	
    	elapsedTime = new Date().getTime() - startTime.getTime();

    	int destID = new Long(cmd.getSource()).intValue();
    	int sourceID = this.getAgentID();
    	int contextID = new Long(cmd.getContext()).intValue();
    	StringBuffer sbuf = new StringBuffer();
    	sbuf.append("<Cmd src="+"\""+sourceID+"\"");
    	sbuf.append(" dest="+"\""+destID+"\"");
    	sbuf.append(" ctxt="+"\""+contextID+"\">");
    	sbuf.append("<"+agentRunningTag+" iid=\""+TIMECOLLECTOR_INTERFACE+"\">");
    	sbuf.append("<time>"+elapsedTime+"</time>");
    	sbuf.append("</"+agentRunningTag+">"+"</Cmd>");
    	try
    	{
    	    super.sendCommand(sbuf.toString());
    	    ret = 0;
    	    //running = false;
    	}
    	catch(Exception e){e.printStackTrace();}

    	return ret;
    }

    private int sendStopResponse(CommandFragment cmd)
    {
    	int ret = -1;
    	endTime = new Date();
    	elapsedTime = endTime.getTime() - startTime.getTime();

    	int destID = new Long(cmd.getSource()).intValue();
    	int sourceID = this.getAgentID();
    	int contextID = new Long(cmd.getContext()).intValue();
    	StringBuffer sbuf = new StringBuffer();
    	sbuf.append("<Cmd src="+"\""+sourceID+"\"");
    	sbuf.append(" dest="+"\""+destID+"\"");
    	sbuf.append(" ctxt="+"\""+contextID+"\">");
    	sbuf.append("<"+agentStoppedTag+" iid=\""+TIMECOLLECTOR_INTERFACE+"\">");
    	sbuf.append("<time>"+elapsedTime+"</time>");
    	sbuf.append("</"+agentStoppedTag+">"+"</Cmd>");
    	try
    	{
    	    super.sendCommand(sbuf.toString());
    	    for(int i = 0; i < 10; i++)
    	    super.sendData(destID,"JTC HELLO FROM JTC ".toCharArray());
    	    ret = 0;
    	    //running = false;
    	}
    	catch(Exception e){e.printStackTrace();}

    	return ret;
    }
}
