/*******************************************************************************
 * Copyright (c) 2005, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Vishnu K Naikawadi,Intel - Initial API and implementation
 *
 * $Id: TPTPProcess.java,v 1.30 2008/03/20 12:28:59 kkazakevi Exp $ 
 *******************************************************************************/ 
package org.eclipse.tptp.platform.execution.samples;
/**
 * This sample connects to an Agent Controller running on the local host
 * and performs process launch. 
 * <Pre>
 * 		i) Validate the process
 * 	   ii) Launch the process and request console for reading and writing to the application
 * 	   iii)Following the launch - retrieve data from the application using the console and write to the console.
 * </Pre>
 * @author gnagaraj
 *
 */
import org.eclipse.tptp.platform.execution.client.core.ConnectionInfo;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.IConsole;
import org.eclipse.tptp.platform.execution.client.core.IDataProcessor;
import org.eclipse.tptp.platform.execution.client.core.INode;
import org.eclipse.tptp.platform.execution.client.core.IProcess;
import org.eclipse.tptp.platform.execution.client.core.NodeFactory;
import org.eclipse.tptp.platform.execution.client.core.internal.IProcessListener;

public class TPTPProcess
{
	static String localhost;
	static int port;
	static String executable;

	private static void InitParameters(String[] args) {
		// set default values
		localhost = "127.0.0.1";
		port = 10006;
		String os = System.getProperty("os.name").toLowerCase();
		if(os.startsWith("windows")) {
			executable = ".\\SampleClient.exe";
		} else {
			executable = "./SampleClient";	
		}

		// parse command line
		int KEY = 0;
		int VALUE_HOST = 1;
		int VALUE_PORT = 2;
		int VALUE_EXECUTABLE = 3;

		int state = KEY; 
		for (int i = 0; i < args.length; i++) {
			if (state == VALUE_HOST) {
				localhost = args[i];
				state = KEY;
				continue;
			}
			if (state == VALUE_PORT) {
				port = (new Integer(args[i])).intValue();
				state = KEY;
				continue;
			}
			if (state == VALUE_EXECUTABLE) {
				executable = args[i];
				state = KEY;
				continue;
			}
			if (args[i].equalsIgnoreCase("-host")) {
				state = VALUE_HOST;
				continue;
			}
			if (args[i].equalsIgnoreCase("-port")) {
				state = VALUE_PORT;
				continue;
			}
			if (args[i].equalsIgnoreCase("-executable")) {
				state = VALUE_EXECUTABLE;
				continue;
			}
		}
	}

    public static void main(String[] args)
	{
    	InitParameters(args);
   	
    	//Connect to the host where the Agent Controller is running
	    //See the Getting started guide for TPTP 4.0 

		//Create a Node that represents the target agent controller
		INode SampleNode = null;
		//Create the client Agent Controller representation object
		IAgentController ac = null;
		//Pass the connection info the client
		ConnectionInfo connInfo = new ConnectionInfo();
		
		try
		{
			//Create a Node that represents the target machine and agent controller
			SampleNode = NodeFactory.createNode(localhost);
			//Set the connection parameters required 
			connInfo.setHostName(localhost);
			connInfo.setPort(port);
			//connInfo.setAgentControllerNew(true);

			if (SampleNode != null)
			{
				// Connect to the Agent Controller, a successful connection returns 
			    //a client side Agent Controller object that provides various 
			    //methods to perform TPTP tasks.
				System.out.println("Connecting to AC..");
				ac = SampleNode.connect(connInfo);

				System.out.println("Connected to " + localhost + " at port number " + port);
				//Create a process object that encapsulates process related attributes
				final IProcess proc = ac.createProcess();				
				
				//Set the attribute exe name on the process object
				proc.setExecutable(executable);
				//Set the attribute location - where the executable is located on the system where the
				//agent controller is executing
				proc.setLocation(".");
				//Validate this process to check if the executable and the directory is valid
				boolean b = proc.validateProcessToLaunch();
				if(b){System.out.println("Validate Process - True"); /*_done=false;*/}
				else{System.out.println("Validate Process - False");/*_done=false;*/}
				//For the same process object created - create a console 
				//and set the data processor required for the console.
				IConsole console = proc.getConsole();
				IDataProcessor dp = new ClientDataProcessor("stdin");
				console.setDataProcessor(dp, IConsole.STDOUT);
				IDataProcessor edp = new ClientDataProcessor("stderr");
				console.setDataProcessor(edp, IConsole.STDERR);
				//Launch the process. At this point the process object information 
				//is sent to the Agent Controller that in turn hands it over to the process 
				//controller agent to launch the process.
				proc.addProcessListener(new IProcessListener(){

					public void processExited(IProcess process) 
					{
						System.out.println("Process exited.");
						synchronized(proc){
							proc.notify();
						}
					}

					public void processLaunched(IProcess process) 
					{
						System.out.println("Process launched.");
						synchronized(proc){
							proc.notify();
						}
					}
				});
				proc.launch();
				
				System.out.println("Process ID ::=>>"+ proc.getProcessId());
				//If the process launch is successful read and write to the console
				if(console.getDataProcessor() != null && proc.getProcessId() > 0)
				{
					
					for(int i = 0; i < 10; i ++)
					{
						StringBuffer buf = new StringBuffer();
						for(int ii = 0; ii < 10; ii ++)
						{
							buf.append("Write from the client \n");
						}
						console.write(buf.toString());
						console.write("\n");
					}
					
				}
								
				synchronized(proc)
				{
					proc.wait();
				}
			}
			else
			{
				System.out.println("Error occurred while creating the Node for " + localhost);
			}
		}
		catch(Exception exp)
		{
			exp.printStackTrace();
			System.out.println("Error occurred while connecting to " + localhost + ":" + exp);
		}		
	}
}
class ClientDataProcessor implements IDataProcessor {
	private String mark;
	
	public ClientDataProcessor (String mark) {
		this.mark = mark;
		if (mark != null) this.mark += ": ";
	}
	
	public void incomingData(byte[] buffer, int length, java.net.InetAddress peer) {
		if (mark != null) System.out.print(mark);
		System.out.println(new String(buffer, 0, length));
	}
	
	public void incomingData(char[] buffer, int length, java.net.InetAddress peer){
		if (mark != null) System.out.print(mark);
		System.out.println(new String(buffer, 0, length));
	}
	
	public void invalidDataType(byte[] data, int length, java.net.InetAddress peer){}
	
	public void waitingForData(){}

}
