/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IKeystoreManager.java,v 1.4 2005/10/03 22:03:03 gnagarajan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.execution.security;

import java.security.Provider;

import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

/**
 * KeyStoreManager required for Agent Controller secure communication
 * <B>This interface is not implemented in TPTP 4.1</B>
 */
public interface IKeystoreManager {

	/**
	 * Set the Security Provider
	 */
	public void setProvider(Provider provider);

	/**
	 * Load the Key Store for the Security configuration
	 */
	public void loadKeystore(String filename, String password) throws java.security.KeyStoreException, java.security.NoSuchAlgorithmException, java.security.UnrecoverableKeyException, java.security.KeyManagementException, java.security.cert.CertificateException, java.io.IOException;

	/**
	 * Get the Security Key Store Managers
	 */
	public KeyManager[] getKeyManagers();

	/**
	 * Get the Security Trust Managers
	 */
	public TrustManager[] getTrustManagers();

}
